package com.cloudam.cromwell;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.cloudam.cromwell.constant.CloudamURL;
import com.cloudam.cromwell.core.CreateJobRequest;
import com.cloudam.cromwell.core.CreateJobResponse;
import com.cloudam.cromwell.core.WorkSpaceFactory;
import com.cloudam.cromwell.domain.Job;
import com.cloudam.cromwell.domain.JobDescription;
import com.cloudam.cromwell.http.HttpUtil;
import okhttp3.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudamClient {


    private final String workSpace;

    private final String accessToken;

    private final Logger logger = LoggerFactory.getLogger(CloudamClient.class);

    public CloudamClient(String env, String accessToken) {
        this.workSpace = env;
        this.accessToken = accessToken;
        auth();
    }

    private void auth() {
        String baseUrl = WorkSpaceFactory.getBaseUrl(this.workSpace);
        // 这里是发送请求校验token是否合法
        Request.Builder request = HttpUtil.getBuilder(this.accessToken)
                .url(baseUrl + CloudamURL.AUTH_URL_SUFFIX)
                .get();
        Response response = HttpUtil.execNormalHttpRequest(request, 3);
        if (response == null || response.code() != 200 || response.body() == null) {
            throw new IllegalArgumentException("the user access token invalid：" + this.accessToken);
        }
        response.close();
    }

    public <T extends CloudamResponse> T doAction(CloudamRequest<T> cloudamRequest) {
        String baseUrl = WorkSpaceFactory.getBaseUrl(this.workSpace);

        CloudamResponse cloudamResponse = null;
        Response response = null;
        try {
            Request.Builder request = cloudamRequest.getBuilder(HttpUtil.getBuilder(this.accessToken), baseUrl, cloudamRequest);
            response = HttpUtil.execNormalHttpRequest(request, 3);
            if (response != null && response.code() == 200 && response.body() != null) {
                Job job = JSON.parseObject(response.body().bytes(), Job.class);
                cloudamResponse = cloudamRequest.getResponseClass().getDeclaredConstructor().newInstance();
                cloudamResponse.setJob(job);
            }
        } catch (Exception e) {
            logger.error("Failed to invoke http request from cloudam, method: {}, request param: {}, e:{}", cloudamRequest.getClass().getSimpleName(), JSON.toJSONString(cloudamRequest), e);
        } finally {
            if (response != null){
                response.close();
            }
        }
        logger.info("class {}, response:{}", cloudamRequest.getResponseClass(), JSON.toJSONString(cloudamResponse));
        return (T) cloudamResponse;
    }

    public static void main(String[] args) {
        CreateJobRequest createJobRequest = new CreateJobRequest();
        String json = "{\"autoCluster\":{\"os\":\"Linux\",\"partition\":\"c-4-1\",\"type\":\"OnDemand\"},\"cpus\":1,\"envs\":{\"cwd\":\"D:\\\\cromwell\\\\slurm\\\\a9d00301-1fed-4607-aa79-86d200914050\\\\call-task_A\",\"stdout\":\"D:\\\\cromwell\\\\slurm\\\\a9d00301-1fed-4607-aa79-86d200914050\\\\call-task_A\\\\stdout\",\"stderr\":\"D:\\\\cromwell\\\\slurm\\\\a9d00301-1fed-4607-aa79-86d200914050\\\\call-task_A\\\\stderr\"},\"gpus\":0,\"name\":\"cloudam_a9d00304_task_A\",\"ntasks\":2,\"projectId\":\"aaa\",\"timeout\":10000,\"zoneId\":\"CE-Z1\"}";
        JobDescription jobDescription = JSONObject.parseObject(json, JobDescription.class);
        createJobRequest.setJobDescription(jobDescription);
        CloudamClient cloudamClient = new CloudamClient("release", "61f00e1a-3142-405e-8298-b7b2bab41d28");
        CreateJobResponse createJobResponse = cloudamClient.doAction(createJobRequest);
        System.out.println(JSON.toJSONString(createJobResponse));
    }

}
