package com.cloudam.cromwell.core;

import com.cloudam.cromwell.CloudamRequest;
import com.cloudam.cromwell.constant.CloudamURL;
import okhttp3.Request;

public class CancelJobRequest extends CloudamRequest<CancelJobResponse> {

    private final String urlSuffix = CloudamURL.CANCEL_JOB_URL_SUFFIX;

    private String jobId;

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Class<CancelJobResponse> getResponseClass() {
        return CancelJobResponse.class;
    }

    @Override
    public Request.Builder getBuilder(Request.Builder builder, String url, CloudamRequest<CancelJobResponse> cloudamRequest) {
        CancelJobRequest cancelJobRequest = (CancelJobRequest) cloudamRequest;
        return builder
                .url(url + cancelJobRequest.urlSuffix + "?requestId=" + cancelJobRequest.getJobId())
                .delete();
    }
}
