package com.cloudam.cromwell.core;

import com.cloudam.cromwell.CloudamRequest;
import com.cloudam.cromwell.constant.CloudamURL;
import okhttp3.Request;

public class GetJobRequest extends CloudamRequest<GetJobResponse> {

    private final String urlSuffix = CloudamURL.GET_JOB_URL_SUFFIX;

    private String jobId;

    public String getJobId() {
        return jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    @Override
    public Class<GetJobResponse> getResponseClass() {
        return GetJobResponse.class;
    }

    @Override
    public Request.Builder getBuilder(Request.Builder builder, String url, CloudamRequest<GetJobResponse> cloudamRequest) {
        GetJobRequest getJobRequest = (GetJobRequest) cloudamRequest;
        return builder
                .url(url + getJobRequest.urlSuffix + "?requestId=" + getJobRequest.getJobId())
                .get();
    }
}
