package com.cloudam.cromwell.core;

import com.cloudam.cromwell.constant.CloudamURL;

import java.util.HashMap;
import java.util.Map;

public class WorkSpaceFactory {

    private final static Map<String, String> WORKSPACE_MAP = new HashMap<String, String>(){
        {
            put("dev", CloudamURL.BASE_DEV_URL);
            put("release", CloudamURL.BASE_RELEASE_URL);
            put("prod", CloudamURL.BASE_PROD_URL);
        }
    };

    public static String getBaseUrl(String env){
        return WORKSPACE_MAP.get(env);
    }
}
