package com.cloudam.cromwell.domain;

import java.util.Map;

/**
 * @author lglhope
 *
 * 作业描述，用于配置生成sbatch.submit文件执行命令
 */
public class JobDescription {

    /**
     * 作业名称
     */
    private String name;

    /**
     * 作业用户名
     */
    private String username;

    /**
     * 作业用户名
     */
    private String workflowJobId;

    /**
     * 计算区ID
     */
    private String zoneId;

    /**
     * 计算区ID
     */
    private String projectId;

    /**
     * 集群配置
     */
    private AutoCluster autoCluster;

    /**
     * 执行命令
     */
    private String workScript;

    /**
     * 环境变量
     */
    private Map<String, String> envs;

    /**
     * CPUs核数(-c)
     */
    private int cpus;

    /**
     * GPUs核数(-g)
     */
    private int gpus;

    /**
     * 任务数(-n)
     */
    private int ntasks;

    /**
     * 超时时间(-t)
     */
    private int timeout;

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUsername() {
        return username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getWorkflowJobId() {
        return workflowJobId;
    }

    public void setWorkflowJobId(String workflowJobId) {
        this.workflowJobId = workflowJobId;
    }

    public String getZoneId() {
        return zoneId;
    }

    public void setZoneId(String zoneId) {
        this.zoneId = zoneId;
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public AutoCluster getAutoCluster() {
        return autoCluster;
    }

    public void setAutoCluster(AutoCluster autoCluster) {
        this.autoCluster = autoCluster;
    }

    public String getWorkScript() {
        return workScript;
    }

    public void setWorkScript(String workScript) {
        this.workScript = workScript;
    }

    public Map<String, String> getEnvs() {
        return envs;
    }

    public void setEnvs(Map<String, String> envs) {
        this.envs = envs;
    }

    public int getCpus() {
        return cpus;
    }

    public void setCpus(int cpus) {
        this.cpus = cpus;
    }

    public int getGpus() {
        return gpus;
    }

    public void setGpus(int gpus) {
        this.gpus = gpus;
    }

    public int getNtasks() {
        return ntasks;
    }

    public void setNtasks(int ntasks) {
        this.ntasks = ntasks;
    }

    public int getTimeout() {
        return timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }
}
