package com.cloudam.cromwell.http;

import com.cloudam.cromwell.CloudamClient;
import okhttp3.Call;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class HttpUtil {

    private final static Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    public static Request.Builder getBuilder(String accessToken) {
        return new Request.Builder()
                .addHeader("Content-Type", "application/json")
                .addHeader("authorization", "Bearer " + accessToken);
    }

    public static Response execNormalHttpRequest(Request.Builder builder, int MAX_RETRIES) {
        Request request = builder.build();

        int retries = 0;
        while (retries < MAX_RETRIES) {
            try {
                OkHttpClient okHttpClient = new OkHttpClient.Builder()
                        .readTimeout(600, TimeUnit.SECONDS)
                        .writeTimeout(60, TimeUnit.SECONDS)
                        .connectTimeout(5, TimeUnit.SECONDS).build();
                final Call call = okHttpClient.newCall(request);
                Response response = call.execute();
                if (response == null || response.code() != 200) {
                    logger.error("fail to execHttpRequest:{} ,url: {} ", "code not equal 200", request.url().uri().toString());
                }
                return response;

            } catch (IOException e) {
                logger.error("fail to execHttpRequest ,reason: {} ", e.getMessage(), e);
                retries++;
                try {
                    Thread.sleep(3000);
                } catch (InterruptedException ex) {
                }
            }
        }
        return null;
    }
}
