import React, { useState } from 'react';
import Snackbar from '@mui/material/Snackbar';
import { SnackbarContent } from '@mui/material';
import Button from '@mui/material/Button';
import IconButton from '@mui/material/IconButton';
import CloseIcon from '@mui/icons-material/Close';
import { useNavigate } from 'react-router-dom';

export default () => {
    const navigate = useNavigate();
    const [onloading, setOnloading] = useState(false);
    const [messages, setMessages] = useState({
        message: '',
        messagetype: '',
    });
    const handleClose = (e) => {
        console.log('e: ', e);
    };

    const action = (
        <React.Fragment>
            <IconButton
                size="small"
                aria-label="close"
                color="inherit"
                onClick={handleClose}
            >
                <CloseIcon fontSize="small" />
            </IconButton>
        </React.Fragment>
    );

    const render = (dom) => {
        return (
            <React.Fragment>
                {dom}
                <Snackbar
                    anchorOrigin={{
                        vertical: 'top',
                        horizontal: 'center',
                    }}
                    open={messages['message'] ? true : false}
                    onClose={handleClose}
                    message="I love snacks"
                    key={messages['message']}
                    action={action}
                />
            </React.Fragment>
        );
    };

    return { render, navigate, setMessages, setOnloading };
};
