/* eslint import/prefer-default-export: off */
import { URL } from 'url';
import path from 'path';
const { resolve } = require('path');

export function resolveHtmlPath(htmlFileName: string) {
  if (process.env.NODE_ENV === 'development') {
    const port = process.env.PORT || 1212;
    const url = new URL(`http://localhost:${port}`);
    url.pathname = htmlFileName;1234
    let goPath  = url.href.replace('%23', '#')
    return goPath;
  }else{
    let opts = require('url').format({
        protocol: 'file:',
        slashes: true,
        pathname: resolve(__dirname, '../renderer/'),
        hash:htmlFileName
    })
    // return `file://${path.resolve(__dirname, '../renderer/', htmlFileName)}`;
return opts
  }
}
