import { HashRouter as Router, Route, Switch, Routes } from 'react-router-dom';
import { Switch } from 'react-router-dom';
import icon from '../../assets/icon.svg';
import { createBrowserHistory } from 'history';
import './App.css';
import path from 'path';
import { ThemeProvider, createTheme } from '@mui/material/styles';
import indexRoutes from '../commons/routes/index';
import { Provider } from 'react-redux';
import store from '../commons/reduxs/store';

const rootPath = require('electron-root-path').rootPath;
const { shell } = require('electron');
const location = path.join(
    rootPath.substring(0, rootPath.length - 8),
    './assets/script/start.vbs'
);

const hist = createBrowserHistory();
const theme = createTheme({
    typography: {
        fontFamily: [
            'Roboto',
            'Helvetica',
            'Tahoma',
            'Arial',
            '"PingFang SC"',
            '"Hiragino Sans GB"',
            '"Heiti SC"',
            '"WenQuanYi Micro Hei"',
            'sans-serif',
            '"Apple Color Emoji"',
            '"Segoe UI Emoji"',
            '"Segoe UI Symbol"',
        ].join(','),
    },
    palette: {
        primary: { main: '#136EFA' },
        secondary: { main: '#F44335' },
    },
});

export default function App() {
    return (
        <Provider store={store}>
            <ThemeProvider theme={theme}>
                <Router history={hist} basename={'/'}>
                    <Routes>
                        {indexRoutes.map((prop, key) => {
                            return (
                                <Route
                                    exact={prop.exact}
                                    path={prop.path}
                                    element={prop.component}
                                    key={key}
                                />
                            );
                        })}
                    </Routes>
                </Router>
            </ThemeProvider>
        </Provider>
    );
}
