import React, { useState } from 'react';

//js
import public from 'commons/public';
import { getUserInfo } from '../../commons/utils/publicMethod';

//ui
import TextField from '@mui/material/TextField';
import { Grid } from '@mui/material';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import { makeStyles } from 'tss-react/mui';
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FolderOpenIcon from '@mui/icons-material/FolderOpen';
import MenuItem from '@mui/material/MenuItem';
import KeyboardArrowLeftIcon from '@mui/icons-material/KeyboardArrowLeft';
import Tooltip from '@mui/material/Tooltip';
import avatar from '../../commons/assets/img/avatar.svg';
import fileIcon from '../../commons/assets/img/fileIcon.svg';
import appIcon from '../../commons/assets/img/appIcon.svg';
import commandIcon from '../../commons/assets/img/commandIcon.svg';
import homeIcon from '../../commons/assets/img/homeIcon.svg';
import siteIcon from '../../commons/assets/img/siteIcon.svg';

const { ipcRenderer } = require('electron');
const electron = window.require('electron');

const useStyles = makeStyles()((theme) => {
    return {
        headBody: {
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'space-between',
            width: '300px',
            margin: '0 auto',
            marginTop: '2%',
        },
        leftBox: {
            display: 'flex',
            alignItems: 'end',
            height: '38px',
            cursor: 'pointer',
        },
        name: {
            fontSize: '14px',
            fontWeight: '500',
            whiteSpace: 'nowrap',
            overflow: 'hidden',
            textOverflow: 'ellipsis',
            width: '110px',
        },
        leftBox2: {
            display: 'flex',
            alignItems: 'center',
            height: '38px',
        },
        rightBox: {
            display: 'flex',
        },
        siteBox: {
            width: '176px',
            height: '116px',
            background: '#FFFFFF',
            boxShadow: '0px 4px 10px 0px rgba(25,37,61,0.24)',
            borderRadius: '8px',
            border: '2px solid rgba(255,255,255,0.65)',
            position: 'absolute',
            top: '40px',
            right: '20px',
            zIndex: '100',
        },
        siteText: {
            fontSize: '14px',
            color: '#1E2633',
            cursor: 'pointer',
            padding: '0 16px',
            // marginTop: '12px',
            display: 'flex',
            alignItems: 'center',
            height: '24px',
            '&:hover': {
                background: '#F0F2F5',
            },
        },
    };
});

const list = [
    { id: '1', value: fileIcon, lable: '云文件' },
    { id: '2', value: appIcon, lable: '云应用' },
    { id: '3', value: commandIcon, lable: '云终端' },
    { id: '4', value: homeIcon, lable: '控制台' },
    { id: '5', value: siteIcon, lable: '设置' },
];

export default (props) => {
    console.log('props: ', props);
    const { classes } = useStyles();
    const { render, navigate } = public();

    const [level, setLevel] = useState(props.level);
    const [hover, setHover] = useState(false);
    const [open, setOpen] = useState(false);

    const iconClick = (e) => {
        console.log('e: ', e);
        switch (e) {
            case '1':
                return;
            case '5':
                setOpen(true);
                return;
            default:
                return;
        }
    };

    return (
        <Grid className={classes.headBody}>
            {!level ? (
                <Grid
                    className={classes.leftBox}
                    onClick={() => {
                        setLevel(true);
                        navigate('/details');
                    }}
                    onMouseEnter={() => {
                        setHover(true);
                    }}
                    onMouseLeave={() => {
                        setHover(false);
                    }}
                >
                    <img src={avatar} alt="" />
                    <Grid sx={{ marginLeft: '8px' }}>
                        <Grid
                            className={classes.name}
                            sx={{ color: hover ? '#1370FF' : '#1E2633' }}
                        >
                            {getUserInfo().name}
                            {/* yaojierui100@gamil.com */}
                        </Grid>
                        <Grid sx={{ fontSize: '12px', color: '#B7B9BD' }}>
                            已用200TB
                        </Grid>
                    </Grid>
                </Grid>
            ) : (
                <Grid className={classes.leftBox2}>
                    <KeyboardArrowLeftIcon
                        onClick={() => {
                            setLevel(false);
                            navigate('/home');
                        }}
                        style={{ cursor: 'pointer' }}
                    />
                    <Grid
                        sx={{
                            fontSize: '14px',
                            color: '#1E2633',
                            marginLeft: '5px',
                            fontWeight: '600',
                        }}
                    >
                        账号详情
                    </Grid>
                </Grid>
            )}

            <Grid className={classes.rightBox}>
                {list.map((e, key) => {
                    return (
                        <Tooltip title={e.lable} arrow key={key}>
                            <img
                                src={e.value}
                                alt={e.id}
                                style={{
                                    marginLeft: '14px',
                                    cursor: 'pointer',
                                }}
                                onClick={() => {
                                    iconClick(e.id);
                                }}
                            />
                        </Tooltip>
                    );
                })}

                <Grid
                    sx={{ display: open ? 'block' : 'none' }}
                    onMouseLeave={(e) => setOpen(false)}
                    className={classes.siteBox}
                >
                    <Grid
                        className={classes.siteText}
                        sx={{ margin: '8px 0px 6px 0px' }}
                        onClick={() => {
                            // navigate('/site');
                            // electron.ipcRenderer.send('resize-site');
                            electron.ipcRenderer.send('createNewWindow');
                        }}
                    >
                        云盘设置
                    </Grid>
                    <Grid
                        className={classes.siteText}
                        onClick={() => {
                            // navigate('/site');
                            electron.ipcRenderer.send('resize-site');
                        }}
                    >
                        偏好设置
                    </Grid>
                    <Grid
                        sx={{
                            width: '176px',
                            height: '1px',
                            border: '1px solid #EDEFF2',
                            margin: '10px 0px 8px 0px',
                        }}
                    ></Grid>
                    <Grid
                        className={classes.siteText}
                        onClick={() => {
                            electron.ipcRenderer.send('window-close');
                        }}
                    >
                        退出应用
                    </Grid>
                </Grid>
            </Grid>
        </Grid>
    );
};
