import React, { useState } from 'react';

//js
import public from 'commons/public';

//ui
import TextField from '@mui/material/TextField';
import { Grid } from '@mui/material';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import { makeStyles } from 'tss-react/mui';
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FolderOpenIcon from '@mui/icons-material/FolderOpen';
import MenuItem from '@mui/material/MenuItem';
import file from '../../commons/assets/img/file.svg';

const useStyles = makeStyles()((theme) => {
    return {
        mountBody: {
            display: 'flex',
            alignItems: 'flex-start',
            flexDirection: 'column',
            width: '300px',
            // margin: '0 auto',
            marginTop: '1.5%',
            marginLeft: '24px',
        },
        title: {
            fontSize: '16px',
            fontWeight: '600',
            color: '#1E2633',
            marginBottom: '16px',
        },
        root: {
            height: '36px',
            width: '252px',
        },
        input: {
            padding: '6.5px 14px',
        },
    };
});

const currencies = [
    {
        value: 'USD',
        label: '$',
    },
    {
        value: 'EUR',
        label: '€',
    },
    {
        value: 'BTC',
        label: '฿',
    },
    {
        value: 'JPY',
        label: '¥',
    },
];

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();

    const [mountValue, setMountValue] = useState('localDisk');
    const [currency, setCurrency] = useState('EUR');

    const handleChange = (event) => {
        event.stopPropagation();
        setMountValue(event.target.value);
    };

    const handleSelectChange = (event) => {
        setCurrency(event.target.value);
    };

    return (
        <Grid className={classes.mountBody}>
            <Grid className={classes.title}>挂载位置</Grid>

            <RadioGroup value={mountValue} onChange={handleChange}>
                <FormControlLabel
                    value="localDisk"
                    control={<Radio size="small" />}
                    sx={{ alignItems: 'flex-start', display: 'flex' }}
                    label={
                        <Grid sx={{ marginTop: '8px' }}>
                            <Grid
                                sx={{
                                    color: '#1E2633',
                                    fontSize: '14px',
                                    marginBottom: '10px',
                                }}
                            >
                                将云文件挂载到本地磁盘
                            </Grid>
                            <TextField
                                select
                                value={currency}
                                onChange={handleSelectChange}
                                InputProps={{
                                    classes: {
                                        root: classes.root,
                                        input: classes.input,
                                    },
                                }}
                            >
                                {currencies.map((option) => (
                                    <MenuItem
                                        key={option.value}
                                        value={option.value}
                                    >
                                        {option.label}
                                    </MenuItem>
                                ))}
                            </TextField>
                        </Grid>
                    }
                />
                <FormControlLabel
                    value="localFolder"
                    control={<Radio size="small" />}
                    sx={{
                        alignItems: 'flex-start',
                        display: 'flex',
                        marginTop: '20px',
                    }}
                    label={
                        <Grid
                            sx={{ marginTop: '8px' }}
                            onClick={(event) => {
                                event.stopPropagation();
                            }}
                        >
                            <Grid
                                sx={{
                                    color: '#1E2633',
                                    fontSize: '14px',
                                    marginBottom: '10px',
                                }}
                            >
                                将云盘挂载到本地文件夹
                            </Grid>

                            <Grid
                                sx={{
                                    display: 'flex',
                                    alignItems: 'center',
                                }}
                            >
                                <img src={file} alt="" />
                                <Grid
                                    sx={{
                                        color: '#8A9099',
                                        fontSize: '14px',
                                        marginLeft: '10px',
                                    }}
                                >
                                    C:\Users\…\Desktopopsjw
                                </Grid>
                                <Grid
                                    sx={{
                                        color: '#1370FF',
                                        fontSize: '14px',
                                        marginLeft: '16px',
                                        cursor: 'pointer',
                                    }}
                                    onClick={(event) => {
                                        event.stopPropagation();
                                        console.log('222222222');
                                    }}
                                >
                                    更改
                                </Grid>
                            </Grid>
                        </Grid>
                    }
                />
            </RadioGroup>
        </Grid>
    );
};
