import React, { useState } from 'react';
import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import { Grid } from '@mui/material';
import { makeStyles } from 'tss-react/mui';

const useStyles = makeStyles()((theme) => {
    return {
        indicator: {
            height: '3px',
        },
        tabRoot: {
            opacity: '1',
            minWidth: '50%',
            boxShadow: 'none',
            '&:hover': {
                transform: 'inherit',
                backgroundColor: '#F5F6F7',
            },
        },
        flexContainer: {
            // justifyContent: 'space-around',
        },
        line: {
            width: '100%',
            height: '1px',
            border: '1px solid #EDEFF2',
        },
    };
});

export default (props) => {
    const { classes } = useStyles();
    const [value, setValue] = useState('one');

    const handleChange = (event, newValue) => {
        setValue(newValue);
    };

    return (
        <Grid sx={{ width: '100%', marginTop: '5px' }}>
            <Tabs
                value={value}
                onChange={handleChange}
                classes={{
                    indicator: classes.indicator,
                    flexContainer: classes.flexContainer,
                }}
            >
                <Tab
                    value="one"
                    label={<Grid>传输</Grid>}
                    classes={{
                        root: classes.tabRoot,
                    }}
                />
                <Tab
                    value="two"
                    label={<Grid>通知</Grid>}
                    classes={{
                        root: classes.tabRoot,
                    }}
                />
            </Tabs>
            <Grid className={classes.line}></Grid>
        </Grid>
    );
};
