import React, { useState } from 'react';
import public from 'commons/public';
import Mount from '../components/mount';
import Preference from '../components/preference';
import { Button, Grid } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
const { ipcRenderer } = require('electron');
const electron = window.require('electron');

const useStyles = makeStyles()((theme) => {
    return {
        siteBody: {
            display: 'flex',
            marginLeft: '-8px',
            marginTop: '19px',
            // flexDirection: 'column',
            // alignItems: 'center',
        },
        text: {
            display: 'flex',
            alignItems: 'center',
            color: '#1E2633',
            width: '126px',
            height: '36px',
            // background: '#E8F0FE',
            // borderRadius: '0px 100px 100px 0px',
            fontSize: '14px',
            paddingLeft: '20px',
            cursor: 'pointer',
        },
        checkText: {
            display: 'flex',
            alignItems: 'center',
            color: '#1370FF',
            width: '126px',
            height: '36px',
            background: '#E8F0FE',
            borderRadius: '0px 100px 100px 0px',
            fontSize: '14px',
            paddingLeft: '20px',
            cursor: 'pointer',
        },
        // rootButton: {
        //     backgroundColor: '#1370FF',
        //     boxShadow: 'none !important',
        //     color: '#ffffff',
        //     '&:hover': { backgroundColor: '#0055D9', transform: 'inherit' },
        // },
    };
});

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();

    const [check, setChecked] = useState('1');

    return (
        <Grid className={classes.siteBody}>
            <Grid>
                <Grid
                    className={check === '1' ? classes.checkText : classes.text}
                    onClick={() => {
                        setChecked('1');
                    }}
                >
                    云盘设置
                </Grid>
                <Grid
                    className={check === '2' ? classes.checkText : classes.text}
                    onClick={() => {
                        setChecked('2');
                    }}
                >
                    偏好设置
                </Grid>
            </Grid>
            {check === '1' && <Mount />}
            {check === '2' && <Preference />}
        </Grid>
    );
};
