import axios from 'axios';
import HeadersComponent from './header';
let headers = {
    'Content-Type': 'application/json',
    'Accept-Language': 'zh-CN,zh;q=0.5', //中文
};
let headersTemp = {};
class Controller {
    static awaitAxios({
        url,
        type,
        param,
        store,
        timeout,
        isheader,
        noheader,
        fileType,
        other,
    }) {
        // 发送 POST 请求
        return new Promise((resolve, reject) => {
            if (isheader && !HeadersComponent(headers)) {
                reject({
                    message: '你还没有登陆或凭证过期，请重新登陆',
                    status: 'error',
                });
                return;
            }
            if (isheader && typeof isheader === 'object') {
                headersTemp = {
                    ...headers,
                    ...isheader,
                };
            }
            const json = {
                url: url || '',
                method: type || 'get',
                responseType: fileType ? 'arraybuffer' : '',
                headers: noheader
                    ? {}
                    : isheader && typeof isheader === 'object'
                    ? headersTemp
                    : headers,
                data: param,
                timeout: timeout || 200000,
                ...other,
            };
            axios(json)
                .then(function (response) {
                    if (fileType) {
                        resolve(response);
                    } else {
                        resolve(response.data);
                    }
                })
                .catch((error) => {
                    reject(error);
                });
        });
    }
}

export default Controller;
