import React, { useState } from 'react';

//js
import public from 'commons/public';

//ui
import TextField from '@mui/material/TextField';
import { Grid, Button } from '@mui/material';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import { makeStyles } from 'tss-react/mui';
import Radio from '@mui/material/Radio';
import RadioGroup from '@mui/material/RadioGroup';
import FolderOpenIcon from '@mui/icons-material/FolderOpen';
import MenuItem from '@mui/material/MenuItem';
import file from '../../commons/assets/img/file.svg';

const useStyles = makeStyles()((theme) => {
    return {
        mountBody: {
            display: 'flex',
            alignItems: 'flex-start',
            flexDirection: 'column',
            width: '100%',
            borderRadius: '4px',
            border: '1px solid #EBEDF0',
            marginLeft: '24px',
            marginRight: '24px',
        },
        title: {
            fontSize: '16px',
            fontWeight: '600',
            color: '#1E2633',
            marginBottom: '16px',
        },
        root: {
            height: '36px',
            width: '252px',
        },
        input: {
            padding: '6.5px 14px',
        },
        buttonGroup: {
            borderTop: '1px solid #EBEDF0',
            height: '63px',
            display: 'flex',
            alignItems: 'center',
            width: '100%',
            justifyContent: 'space-between',
        },
        rootButton: {
            backgroundColor: '#1370FF',
            boxShadow: 'none !important',
            color: '#ffffff',
            '&:hover': { backgroundColor: '#0055D9', transform: 'inherit' },
        },
        rootButton2: {
            backgroundColor: '#F0F2F5',
            boxShadow: 'none !important',
            color: '#1E2633',
            '&:hover': { backgroundColor: '#F0F2F5', transform: 'inherit' },
        },
    };
});

const currencies = [
    {
        value: 'USD',
        label: '$',
    },
    {
        value: 'EUR',
        label: '€',
    },
    {
        value: 'BTC',
        label: '฿',
    },
    {
        value: 'JPY',
        label: '¥',
    },
];

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();

    const [mountValue, setMountValue] = useState('localDisk');
    const [currency, setCurrency] = useState('EUR');

    const [change, setChange] = useState(false);

    const handleChange = (event) => {
        setChange(true);
        event.stopPropagation();
        setMountValue(event.target.value);
    };

    const handleSelectChange = (event) => {
        setChange(true);
        setCurrency(event.target.value);
    };

    return (
        <Grid className={classes.mountBody}>
            <Grid sx={{ padding: '16px 24px' }}>
                <Grid className={classes.title}>挂载位置</Grid>

                <RadioGroup
                    value={mountValue}
                    onChange={handleChange}
                    sx={{ marginBottom: '29px' }}
                >
                    <FormControlLabel
                        value="localDisk"
                        control={<Radio size="small" />}
                        sx={{ alignItems: 'flex-start', display: 'flex' }}
                        label={
                            <Grid sx={{ marginTop: '8px' }}>
                                <Grid
                                    sx={{
                                        color: '#1E2633',
                                        fontSize: '14px',
                                        marginBottom: '10px',
                                    }}
                                >
                                    将云文件挂载到本地磁盘
                                </Grid>
                                <TextField
                                    select
                                    value={currency}
                                    onChange={handleSelectChange}
                                    InputProps={{
                                        classes: {
                                            root: classes.root,
                                            input: classes.input,
                                        },
                                    }}
                                >
                                    {currencies.map((option) => (
                                        <MenuItem
                                            key={option.value}
                                            value={option.value}
                                        >
                                            {option.label}
                                        </MenuItem>
                                    ))}
                                </TextField>
                            </Grid>
                        }
                    />
                    <FormControlLabel
                        value="localFolder"
                        control={<Radio size="small" />}
                        sx={{
                            alignItems: 'flex-start',
                            display: 'flex',
                            marginTop: '20px',
                        }}
                        label={
                            <Grid
                                sx={{ marginTop: '8px' }}
                                onClick={(event) => {
                                    event.stopPropagation();
                                }}
                            >
                                <Grid
                                    sx={{
                                        color: '#1E2633',
                                        fontSize: '14px',
                                        marginBottom: '10px',
                                    }}
                                >
                                    将云盘挂载到本地文件夹
                                </Grid>

                                <Grid
                                    sx={{
                                        display: 'flex',
                                        alignItems: 'center',
                                    }}
                                >
                                    <img src={file} alt="" />
                                    <Grid
                                        sx={{
                                            color: '#8A9099',
                                            fontSize: '14px',
                                            marginLeft: '10px',
                                        }}
                                    >
                                        C:\Users\…\Desktopopsjw
                                    </Grid>
                                    <Grid
                                        sx={{
                                            color: '#1370FF',
                                            fontSize: '14px',
                                            marginLeft: '16px',
                                            cursor: 'pointer',
                                        }}
                                        onClick={(event) => {
                                            event.stopPropagation();
                                            console.log('222222222');
                                        }}
                                    >
                                        更改
                                    </Grid>
                                </Grid>
                            </Grid>
                        }
                    />
                </RadioGroup>

                <Grid className={classes.title}>缓存位置</Grid>
                <Grid>
                    <Grid
                        sx={{
                            color: '#1E2633',
                            fontSize: '14px',
                            marginBottom: '10px',
                        }}
                    >
                        本地缓存的文件目录
                    </Grid>
                    <Grid
                        sx={{
                            display: 'flex',
                            alignItems: 'center',
                        }}
                    >
                        <img src={file} alt="" />
                        <Grid
                            sx={{
                                color: '#8A9099',
                                fontSize: '14px',
                                marginLeft: '10px',
                            }}
                        >
                            C:\Users\…\Desktopopsjw
                        </Grid>
                        <Grid
                            sx={{
                                color: '#1370FF',
                                fontSize: '14px',
                                marginLeft: '16px',
                                cursor: 'pointer',
                            }}
                            onClick={(event) => {
                                event.stopPropagation();
                                console.log('222222222');
                            }}
                        >
                            更改
                        </Grid>
                        <Grid
                            sx={{
                                color: '#1370FF',
                                fontSize: '14px',
                                marginLeft: '16px',
                                cursor: 'pointer',
                            }}
                            onClick={(event) => {
                                event.stopPropagation();
                                console.log('222222222');
                            }}
                        >
                            清除
                        </Grid>
                    </Grid>
                </Grid>
            </Grid>
            <Grid className={classes.buttonGroup}>
                <Grid
                    sx={{
                        fontSize: '14px',
                        color: '#8A9099',
                        marginLeft: '24px',
                        opacity: change ? '1' : '0',
                    }}
                >
                    未保存修改
                </Grid>
                <Grid sx={{ display: 'flex' }}>
                    <Button
                        variant="contained"
                        sx={{ width: '68px' }}
                        disabled={!change}
                        classes={{
                            root: classes.rootButton2,
                        }}
                        onClick={() => {
                            setChange(false);
                        }}
                    >
                        取消
                    </Button>
                    <Button
                        variant="contained"
                        sx={{ width: '68px', margin: '0px 24px 0px 12px' }}
                        disabled={!change}
                        classes={{
                            root: classes.rootButton,
                        }}
                        onClick={() => {}}
                    >
                        保存
                    </Button>
                </Grid>
            </Grid>
        </Grid>
    );
};
