import React, {useState } from 'react';

//js
import public from 'commons/public';

//ui
import TextField from '@mui/material/TextField';
import { Grid } from '@mui/material';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import { makeStyles } from 'tss-react/mui';
import FolderOpenIcon from '@mui/icons-material/FolderOpen';
import file from '../../commons/assets/img/file.svg';

const { ipcRenderer } = require('electron');
const electron = window.require('electron');

const useStyles = makeStyles()((theme) => {
    return {
        preferenceBody: {
            display: 'flex',
            alignItems: 'flex-start',
            flexDirection: 'column',
            width: '100%',
            borderRadius: '4px',
            border: '1px solid #EBEDF0',
            marginLeft: '24px',
            marginRight: '24px',
            height: '100%',
        },
        title: {
            fontSize: '16px',
            fontWeight: '600',
            color: '#1E2633',
            marginBottom: '16px',
        },
    };
});

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();
    const [selfStart, setSelfStart] = useState(localStorage.getItem('Preferences') && JSON.parse(localStorage.getItem('Preferences'))['selfStart']);
    
    const handleChange = (event) => {
        setSelfStart(event.target.checked);
        localStorage.setItem('Preferences', JSON.stringify({selfStart:event.target.checked}));
        // electron.ipcRenderer.send('openAtLogin');

    };

    return (
        <Grid className={classes.preferenceBody}>
            <Grid sx={{ padding: '16px 24px' }}>
                <Grid className={classes.title}>偏好设置</Grid>

                <FormControlLabel
                    control={
                        <Checkbox
                            checked={selfStart}
                            onChange={handleChange}
                            size="small"
                        />
                    }
                    label={
                        <Grid sx={{ color: '#1E2633', fontSize: '14px' }}>
                            开机时运行北鲲云盘
                        </Grid>
                    }
                />
            </Grid>
        </Grid>
    );
};
