import React, { useState } from 'react';
import public from 'commons/public';
import Head from '../components/head';
import Trans from '../components/trans';
import Tab from '../components/tab';
import BottomTip from '../components/buttomTip.jsx';
import Message from '../components/message.jsx';

import { Button, Grid } from '@mui/material';
import { makeStyles } from 'tss-react/mui';

const useStyles = makeStyles()((theme) => {
    return {
        initBody: {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
        },
    };
});

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();
    const [value, setValue] = useState('one');

    const handleChange = (event, newValue) => {
        setValue(newValue);
    };

    return (
        <Grid className={classes.initBody}>
            <Head />
            <Tab level={false} value={value} handleChange={handleChange} />

            {value === 'one' && <Trans />}
            {value === 'two' && <Message />}

            <BottomTip />
        </Grid>
    );
};
