import React, { useEffect, useState } from 'react';
import { shell } from 'electron';
//js
import { createBrowserHistory } from 'history';
import public from 'commons/public';
import API from '../../commons/utils/api_manager';
import axios from 'axios';
import qs from 'qs';
import { Constants } from '../../commons/utils/constants';
import Axios from '../../commons/axios/Axios';
import { userInfo } from '../../commons/utils/ajaxOption';

//ui
import TextField from '@mui/material/TextField';
import { Button, Grid } from '@mui/material';
import logo from '../../commons/assets/img/logo.svg';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import { makeStyles } from 'tss-react/mui';

const { ipcRenderer } = require('electron');
const electron = window.require('electron');

const useStyles = makeStyles()((theme) => {
    return {
        loginBody: {
            display: 'flex',
            alignItems: 'center',
            flexDirection: 'column',
            width: '300px',
            margin: '0 auto',
            paddingTop: '10%',
            '-webkit-app-region': 'drag'
        },
        root: {
            height: '40px',
            width: '300px',
        },
        input: {
            padding: '7.5px 14px',
        },
        label: {
            fontSize: '14px',
            overflow: 'inherit',
            lineHeight: '8px',
        },
        label2: {
            fontSize: '14px',
        },
        rootButton: {
            backgroundColor: '#1370FF',
            boxShadow: 'none !important',
            color: '#ffffff',
            '&:hover': { backgroundColor: '#0055D9', transform: 'inherit' },
        },
    };
});

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();

    const [username, setUsername] = useState('');
    const [usernameError, setUsernameError] = useState(false);
    const [password, setPassword] = useState('');
    const [passwordError, setPasswordError] = useState(false);
    const [checked, setChecked] = useState(true);


    useEffect(() => {

        if(                    !localStorage.getItem('Preferences')){
            localStorage.setItem('Preferences', JSON.stringify({selfStart:true}));
        }

    }, []);

    const handleChange = (event) => {
        setChecked(event.target.checked);
    };

    const login = async () => {
        if (username.length === 0) {
            setUsernameError(true);
            return;
        } else if (password.length === 0) {
            setPasswordError(true);
            return;
        }

        const options = {
            method: 'post',
            url: API.API_USER_LOGIN,
            headers: {
                'Content-Type': 'application/x-www-form-urlencoded',
                Authorization: 'Basic YnJvd3Nlcjo=',
                'Accept-Language': 'zh-CN,zh;q=0.5',
            },
            data: qs.stringify({
                scope: 'ui',
                username: username,
                password: password,
                grant_type: 'password',
            }),
        };
        axios(options)
            .then(function (response) {
                localStorage.setItem(
                    Constants.TOKEN_KEY,
                    JSON.stringify(response.data)
                );
                 getUserData();
            })
            .catch(function (error) {
                localStorage.removeItem(Constants.TOKEN_KEY);
                localStorage.removeItem(Constants.USER_INFO_TOKEN_KEY);
                localStorage.removeItem(Constants.RAYSYNC_ADDR_TOKEN_KEY);
                localStorage.removeItem(Constants.CURRENT_REGION_SELECT_KEY);
                localStorage.removeItem('site_init');
            });
    };

    const getUserData = async () => {
        let data = await Axios.request(userInfo());
        if (data && data.code === 200) {
            localStorage.setItem(
                Constants.USER_INFO_TOKEN_KEY,
                JSON.stringify(data.res)
            );
            navigate('/home');
            electron.ipcRenderer.send('resize-home');
        }
    };

    return render(
        <Grid className={classes.loginBody}>
            <img
                src={logo}
                alt=""
                style={{ width: '187px', marginBottom: '50px' }}
            />

            <Grid sx={{ marginBottom: '16px' }}>
                <TextField
                    id="username"
                    label="用户名/手机号"
                    variant="outlined"
                    onChange={(e) => {
                        setUsernameError(false);
                        setUsername(e.target.value);
                    }}
                    error={usernameError}
                    helperText={usernameError ? '请输入您的用户名' : ''}
                    InputLabelProps={{
                        classes: {
                            outlined: classes.label,
                        },
                    }}
                    InputProps={{
                        classes: {
                            root: classes.root,
                            input: classes.input,
                        },
                    }}
                />
            </Grid>

            <Grid sx={{ marginBottom: '16px' }}>
                <TextField
                    id="username"
                    label="密码"
                    variant="outlined"
                    type={'password'}
                    onChange={(e) => {
                        setPasswordError(false);
                        setPassword(e.target.value);
                    }}
                    onKeyPress={(event) => {
                        if (event.key === 'Enter') {
                            login();
                            event.preventDefault();
                        }
                    }}
                    error={passwordError}
                    helperText={passwordError ? '请输入您的密码' : ''}
                    InputLabelProps={{
                        classes: {
                            outlined: classes.label,
                        },
                    }}
                    InputProps={{
                        classes: {
                            root: classes.root,
                            input: classes.input,
                        },
                    }}
                />
            </Grid>

            <Grid
                sx={{
                    display: 'flex',
                    alignItems: 'center',
                    justifyContent: 'space-between',
                    width: '100%',
                    marginBottom: '20px',
                }}
            >
                <FormControlLabel
                    classes={{
                        label: classes.label2,
                    }}
                    control={
                        <Checkbox checked={checked} onChange={handleChange} />
                    }
                    label="记住登录状态"
                />
                <Grid
                    sx={{
                        fontSize: '14px',
                        color: '#1370FF',
                        cursor: 'pointer',
                    }}
                    onClick={() => {
                        shell.openExternal(
                            'https://www.bkunyun.com/v2/pages/forgot-password-page'
                        );
                    }}
                >
                    忘记密码
                </Grid>
            </Grid>

            <Button
                variant="contained"
                sx={{ width: '300px' }}
                classes={{
                    root: classes.rootButton,
                }}
                onClick={() => {
                    login();
                    // navigate('/test');
                    // electron.ipcRenderer.send('resize-init');
                }}
            >
                登录
            </Button>

            <Grid sx={{ display: 'flex', fontSize: '14px', marginTop: '44px' }}>
                新用户？
                <span
                    style={{ color: '#1370FF', cursor: 'pointer' }}
                    onClick={() => {
                        // electron.ipcRenderer.send('test');
                        shell.openExternal(
                            'https://www.bkunyun.com/v2/pages/register-page'
                        );
                    }}
                >
                    创建帐号
                </span>
            </Grid>
        </Grid>
    );
};
