import { Constants } from '../utils/constants';

export const getUserInfo = () => {
    return (
        localStorage.getItem(Constants.USER_INFO_TOKEN_KEY) &&
        JSON.parse(localStorage.getItem(Constants.USER_INFO_TOKEN_KEY))
    );
};

export const getCurrentZone = () => {
    let localUtc = new Date().getTimezoneOffset() / 60;
    let Rounding = parseInt(localUtc);
    let Remainder = new Date().getTimezoneOffset() % 60;
    let Remainder2 = Math.abs(Remainder);
    let Remainder3 = '00';
    let timezone = '%2B08:00';
    if ([0, '0'].includes(Remainder2)) {
        Remainder3 = '00';
    } else {
        Remainder3 = Remainder2;
    }
    if (Rounding > 0) {
        if (Rounding >= 10) {
            timezone = '-1' * Rounding + ':' + Remainder3;
        } else {
            timezone = '-0' + Rounding + ':' + Remainder3;
        }
    } else {
        let localTime = Math.abs(Rounding);
        if (localTime < 10) {
            timezone = '%2B0' + localTime + ':' + Remainder3;
        } else {
            timezone = '%2B' + localTime + ':' + Remainder3;
        }
    }
    return timezone;
};
