/* eslint global-require: off, no-console: off, promise/always-return: off */

/**
 * This module executes inside of electron's main process. You can start
 * electron renderer process from here and communicate with the other processes
 * through IPC.
 *
 * When running `npm run build` or `npm run build:main`, this file is compiled to
 * `./src/main.js` using webpack. This gives us some performance wins.
 */
import path from 'path';
import { app, BrowserWindow, shell, ipcMain } from 'electron';

import { autoUpdater } from 'electron-updater';
import log from 'electron-log';
import MenuBuilder from './menu';
import { resolveHtmlPath } from './util';
class AppUpdater {
    constructor() {
        log.transports.file.level = 'info';
        autoUpdater.logger = log;
        autoUpdater.checkForUpdatesAndNotify();
    }
}

let mainWindow: BrowserWindow | null = null;
let win: BrowserWindow | null = null;

ipcMain.on('resize-site', (event) => {
    if (win) {
        win.loadFile('index.html/site');
    }
});

ipcMain.on('createNewWindow', () => {
    win = new BrowserWindow({
        width: 546,
        height: 425,
        minWidth: 100,
        minHeight: 100,
        frame: true,
        resizable: false,
        webPreferences: {
            sandbox: false,
            nodeIntegration: true,
            contextIsolation: false,
            webSecurity: false,
        },
        // parent: win, //win是主窗口
    });
    // win.loadURL(path.join('file:', __dirname, 'new.html')); //new.html是新开窗口的渲染进程
    // win.loadURL('http://localhost:1212/#/site');
    // win.loadFile(path.join(__dirname));
    win.loadFile('./index.html', {
        hash: 'site',
    });
    win.on('closed', () => {
        win = null;
    });
});

ipcMain.on('resize-home', (event) => {
    if (mainWindow) {
        mainWindow.setContentSize(350, 425);
        // mainWindow.setResizable(true);
        mainWindow.setMaximizable(false);
        // mainWindow.center();
    }
});

ipcMain.on('window-close', (event) => {
    app.quit();
});

if (process.env.NODE_ENV === 'production') {
    const sourceMapSupport = require('source-map-support');
    sourceMapSupport.install();
}

const isDebug =
    process.env.NODE_ENV === 'development' || process.env.DEBUG_PROD === 'true';

if (isDebug) {
    require('electron-debug')();
}

const installExtensions = async () => {
    const installer = require('electron-devtools-installer');
    const forceDownload = !!process.env.UPGRADE_EXTENSIONS;
    const extensions = ['REACT_DEVELOPER_TOOLS'];

    return installer
        .default(
            extensions.map((name) => installer[name]),
            forceDownload
        )
        .catch(console.log);
};

const createWindow = async () => {
    if (isDebug) {
        await installExtensions();
    }

    const RESOURCES_PATH = app.isPackaged
        ? path.join(process.resourcesPath, 'assets')
        : path.join(__dirname, '../../assets');

    const getAssetPath = (...paths: string[]): string => {
        return path.join(RESOURCES_PATH, ...paths);
    };

    mainWindow = new BrowserWindow({
        show: false,
        width: 480,
        height: 486,
        minWidth: 100,
        minHeight: 100,
        icon: getAssetPath('icon.png'),
        frame: true,
        resizable: false,
        webPreferences: {
            sandbox: false,
            nodeIntegration: true,
            contextIsolation: false,
            webSecurity: false,
        },
    });

    // win = new BrowserWindow({
    //     show: true,
    //     width: 546,
    //     height: 425,
    //     minWidth: 100,
    //     minHeight: 100,
    //     icon: getAssetPath('icon.png'),
    //     frame: true,
    //     resizable: false,
    //     webPreferences: {
    //         sandbox: false,
    //         nodeIntegration: true,
    //         contextIsolation: false,
    //         webSecurity: false,
    //     },
    // });

    mainWindow.loadURL(resolveHtmlPath('index.html'));

    mainWindow.on('ready-to-show', () => {
        if (!mainWindow) {
            throw new Error('"mainWindow" is not defined');
        }
        if (process.env.START_MINIMIZED) {
            mainWindow.minimize();
        } else {
            mainWindow.show();
        }
    });

    mainWindow.on('closed', () => {
        mainWindow = null;
    });

    const menuBuilder = new MenuBuilder(mainWindow);
    menuBuilder.buildMenu();

    // Open urls in the user's browser
    mainWindow.webContents.setWindowOpenHandler((edata) => {
        shell.openExternal(edata.url);
        return { action: 'deny' };
    });

    // Remove this if your app does not use auto updates
    // eslint-disable-next-line
    new AppUpdater();

    // function initLoginWindow(windowObj: any) {
    //     windowObj.setContentSize(500, 500);
    //     windowObj.setResizable(false);
    //     windowObj.setMaximizable(false);
    //     windowObj.center();
    // }

    // ipcMain.on('showLoginWindow', (event) => {
    //     initLoginWindow(mainWindow);
    // });
};

/**
 * Add event listeners...
 */

app.on('window-all-closed', () => {
    // Respect the OSX convention of having the application in memory even
    // after all windows have been closed
    if (process.platform !== 'darwin') {
        app.quit();
    }
});

app.whenReady()
    .then(() => {
        createWindow();
        app.on('activate', () => {
            // On macOS it's common to re-create a window in the app when the
            // dock icon is clicked and there are no other windows open.
            if (mainWindow === null) createWindow();
        });
    })
    .catch(console.log);
