import React, { useState } from 'react';

//js
import public from 'commons/public';

//ui
import TextField from '@mui/material/TextField';
import { Grid } from '@mui/material';
import FormControlLabel from '@mui/material/FormControlLabel';
import Checkbox from '@mui/material/Checkbox';
import { makeStyles } from 'tss-react/mui';
import FolderOpenIcon from '@mui/icons-material/FolderOpen';
import file from '../../commons/assets/img/file.svg';

const useStyles = makeStyles()((theme) => {
    return {
        preferenceBody: {
            display: 'flex',
            alignItems: 'flex-start',
            flexDirection: 'column',
            width: '300px',
            marginTop: '1.5%',
            marginLeft: '24px',
        },
        title: {
            fontSize: '16px',
            fontWeight: '600',
            color: '#1E2633',
            marginBottom: '16px',
        },
    };
});

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();

    const [selfStart, setSelfStart] = useState(false);

    const handleChange = (event) => {
        setSelfStart(event.target.checked);
    };

    return (
        <Grid className={classes.preferenceBody}>
            <Grid className={classes.title}>偏好设置</Grid>

            <FormControlLabel
                control={
                    <Checkbox
                        checked={selfStart}
                        onChange={handleChange}
                        size="small"
                    />
                }
                label={
                    <Grid sx={{ color: '#1E2633', fontSize: '14px' }}>
                        开机时运行北鲲云盘
                    </Grid>
                }
            />

            <Grid sx={{ marginTop: '8px' }}>
                <Grid
                    sx={{
                        color: '#1E2633',
                        fontSize: '14px',
                        marginBottom: '10px',
                    }}
                >
                    本地缓存的文件目录
                </Grid>
                <Grid
                    sx={{
                        display: 'flex',
                        alignItems: 'center',
                    }}
                >
                    <img src={file} alt="" />
                    <Grid
                        sx={{
                            color: '#8A9099',
                            fontSize: '14px',
                            marginLeft: '10px',
                        }}
                    >
                        C:\Users\…\Desktopopsjw
                    </Grid>
                    <Grid
                        sx={{
                            color: '#1370FF',
                            fontSize: '14px',
                            marginLeft: '16px',
                            cursor: 'pointer',
                        }}
                        onClick={(event) => {
                            event.stopPropagation();
                            console.log('222222222');
                        }}
                    >
                        更改
                    </Grid>
                </Grid>
            </Grid>
        </Grid>
    );
};
