import Controller from './controller';
import store from '../reduxs/store';
import { setRequest } from '../reduxs/actions';
import qs from 'qs';
import API from '../../commons/utils/api_manager';
import { Constants } from '../../commons/utils/constants';
import axios from 'axios';
const { ipcRenderer } = require('electron');
const electron = window.require('electron');
class Axios {
    static async request({
        url = '',
        type = 'get',
        param = {},
        actions,
        timeout,
        isheader = true,
        noheader = false,
        fileType = false,
        other,
    }) {
        try {
            let res = await Controller.awaitAxios({
                url,
                type,
                param,
                timeout,
                isheader,
                noheader,
                fileType,
                other,
            });
            return {
                code: 200,
                status: 'success',
                res,
            };
        } catch (error) {
            if (error.response.data.errorCode === '100003') {
                let reLoad = await Axios.request_reLoad();
                console.log('reLoad: ', reLoad);
                if (reLoad['access_token']) {
                    localStorage.setItem(
                        Constants.TOKEN_KEY,
                        JSON.stringify(data)
                    );
                    window.location.reload();
                } else {
                    setTimeout(() => {
                        localStorage.removeItem(Constants.TEMPORARY_TOKEN_KEY);
                        localStorage.removeItem(Constants.TOKEN_KEY);
                    }, 3000);
                }
                return;
            }
            actions && store.dispatch(setRequest(error));
            if (!actions) {
                return {
                    code: 40001,
                    status: 'fail',
                    error: error.response ? error.response.data : error,
                };
            }
        }
    }

    static request_reLoad() {
        let token =
            localStorage.getItem(Constants.TOKEN_KEY) &&
            JSON.parse(localStorage.getItem(Constants.TOKEN_KEY)).refresh_token;
        let data = qs.stringify({
            scope: 'ui',
            grant_type: 'refresh_token',
            refresh_token: token,
        });
        return new Promise((resolve, reject) => {
            axios
                .post(API.API_USER_LOGIN, data, {
                    headers: {
                        Authorization: 'Basic YnJvd3Nlcjo=',
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                })
                .then(function (response) {
                    console.log('response: ', response);
                    resolve(response.data);
                })
                .catch(function (error) {
                    electron.ipcRenderer.send('openLogin-windown');
                    reject(error);
                });
        });
    }
}
export default Axios;
