import API from './api_manager';
import { getCurrentZone, getUserInfo } from './publicMethod';

// 获取用户基础信息
export const userInfo = () => {
    return {
        url: API.API_USER_CURRENT,
        type: 'get',
        param: {},
        actions: true,
    };
};

// 退出登录
export const logout = () => {
    return {
        url: API.API_USER_LOGOUT,
        type: 'delete',
        param: {},
        actions: true,
    };
};

//获取余额
export const getAccountBalance = () => {
    return {
        url: API.API_DASHBOARD_ACCOUNT + `?zone=${getCurrentZone()}`,
        type: 'get',
        param: {},
        actions: true,
    };
};

//获取通知消息
export const messageData = (page, size) => {
    return {
        url:
            API.API_USER_MESSAGEALL +
            `?receiver=${
                getUserInfo().name
            }&msgType=USER&page=${page}&size=${size}`,
        type: 'get',
        param: {},
        actions: true,
    };
};
