import React, { useEffect, useState, useRef } from 'react';

//ui
import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import { Grid } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
import no_message from '../../commons/assets/img/no_message.svg';
import fileIcon from '../../commons/assets/img/fileData.svg';
import suc from '../../commons/assets/img/suc.svg';
import CloseIcon from '@mui/icons-material/Close';
import CircularProgress from '@mui/material/CircularProgress';

// js
import Axios from '../../commons/axios/Axios';
import API from '../../commons/utils/api_manager';
import { messageData } from '../../commons/utils/ajaxOption';
import { convert_timer } from '../../commons/utils/publicMethod';

const useStyles = makeStyles()((theme) => {
    return {
        no_data: {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            marginTop: '30px',
        },
        listBox: {
            display: 'flex',
            flexDirection: 'column',
            paddingTop: '16px',
            overflow: 'auto',
            overflowX: 'hidden',
            height: '274px',
            alignItems: 'center',
        },
        messageBox: {
            width: '322px',
            // height: '122px',
            background: '#FFFFFF',
            boxShadow: '0px 1px 5px 0px rgba(0,20,46,0.18)',
            // border: '1px solid',
            borderRadius: '8px',
            padding: '16px 20px',
            marginBottom: '16px',
            // minHeight: '122px',
        },
        messageTitle: {
            color: '#1E2633',
            fontSize: '14px',
            fontWeight: '600',
        },
        messageTime: {
            fontSize: '12px',
            color: '#C2C6CC',
            marginRight: '18px',
        },
        boxHead: {
            display: 'flex',
            justifyContent: 'space-between',
        },
        boxBody: {
            marginTop: '8px',
        },
        fold: {
            overflow: 'hidden',
            textOverflow: 'ellipsis',
            display: '-webkit-box',
            position: 'relative',
            '-webkit-line-clamp': '3',
            '-webkit-box-orient': 'vertical',
        },
        open: {
            // overflow: 'hidden',
            textOverflow: 'ellipsis',
            display: '-webkit-box',
            position: 'relative',
            paddingBottom: '20px',
            '-webkit-box-orient': 'vertical',
        },
        messageText: {
            color: '#565C66',
            fontSize: '12px',
            lineHeight: '20px',
        },
        messageOpen: {
            whiteSpace: 'nowrap',
            color: '#1370FF',
            fontSize: '12px',
            cursor: 'pointer',
            position: 'absolute',
            bottom: '0px',
            right: '0px',
            lineHeight: '20px',
            background:
                'linear-gradient(90deg, transparent 10%, rgba(255, 255, 255) 70%)',
            paddingLeft: '60px',
        },
    };
});

export default (props) => {
    const { classes } = useStyles();
    const refs = useRef([]);
    const [domOver, setDomOver] = useState(false);
    const [fold, isFold] = useState(true);
    const [page, setPage] = useState(0);
    const [list, setList] = useState([]);

    useEffect(() => {
        getMessage(0);
    }, []);

    useEffect(() => {
        if (list.length > 0) {
            setDomOver(true);
        }
    }, [list]);

    const getMessage = async (page) => {
        let data = await Axios.request(messageData(page, 10));
        if (data && data.code === 200) {
            let arr = [...list];
            let newarr = [];
            data.res.content.map((item, index) => {
                newarr.push(Object.assign(item, { view: false }));
            });
            arr.push(...newarr);
            setList(arr);
        }
    };

    const isOverflow = (id) => {
        let height = refs.current[id].scrollHeight;
        if (height > 60) {
            return true;
        } else {
            return false;
        }
    };

    const viewCallBack = (e) => {
        setList((p) => {
            let prev = [...p];
            prev.filter((item) => item.id === e.id)[0]['view'] = e.view
                ? false
                : true;
            return prev;
        });
    };

    const scrollEvent = (e) => {
        if (
            e.target.clientHeight + e.target.scrollTop ===
                e.target.scrollHeight - 0.5 ||
            e.target.clientHeight + e.target.scrollTop === e.target.scrollHeight
        ) {
            setPage(page + 1);
            getMessage(page + 1);
            setDomOver(false);
        }
    };

    return (
        <Grid sx={{ width: '100%' }}>
            {list.length === 0 && (
                <Grid className={classes.no_data}>
                    <img src={no_message} alt="" />
                    <Grid sx={{ fontSize: '14px', color: '#B7B9BD' }}>
                        暂无消息
                    </Grid>
                </Grid>
            )}
            <Grid className={classes.listBox} onScroll={scrollEvent}>
                {list.map((e, key) => {
                    return (
                        <Grid
                            className={classes.messageBox}
                            key={key}
                            style={{
                                marginLeft: list.length > 3 ? '8px' : '0px',
                            }}
                        >
                            <Grid className={classes.boxHead}>
                                <Grid className={classes.messageTitle}>
                                    {e.title}
                                </Grid>
                                <Grid
                                    sx={{
                                        display: 'flex',
                                        alignItems: 'center',
                                    }}
                                >
                                    <Grid className={classes.messageTime}>
                                        {convert_timer(e.msgConsumerAt)}
                                    </Grid>
                                    <CloseIcon
                                        style={{
                                            color: '#979797',
                                            fontSize: '20px',
                                            cursor: 'pointer',
                                        }}
                                    />
                                </Grid>
                            </Grid>
                            <Grid className={classes.boxBody}>
                                <Grid
                                    className={
                                        e.view ? classes.open : classes.fold
                                    }
                                >
                                    <Grid
                                        className={classes.messageText}
                                        ref={(element) => {
                                            refs.current[key] = element;
                                        }}
                                    >
                                        {e.text}
                                    </Grid>
                                    {domOver && isOverflow(key) && (
                                        <span
                                            className={classes.messageOpen}
                                            onClick={() => {
                                                viewCallBack(e);
                                            }}
                                        >
                                            {e.view ? '收起' : '展开'}
                                        </span>
                                    )}
                                </Grid>
                            </Grid>
                        </Grid>
                    );
                })}
                <Grid
                    sx={{
                        padding: '4px 0px 20px 0px',
                        display: list.length > 0 ? 'flex' : 'none',
                        alignItems: 'center',
                    }}
                >
                    <CircularProgress
                        style={{
                            color: '#1370FF',
                            width: '12px',
                            height: '12px',
                        }}
                    />
                    <Grid
                        sx={{
                            fontSize: '12px',
                            color: '#565C66',
                            marginLeft: '8px',
                        }}
                    >
                        加载更多…
                    </Grid>
                </Grid>
            </Grid>
        </Grid>
    );
};
