import React, { useState } from 'react';

//ui
import Tabs from '@mui/material/Tabs';
import Tab from '@mui/material/Tab';
import { Grid } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
import no_trans from '../../commons/assets/img/trans.svg';
import fileIcon from '../../commons/assets/img/fileData.svg';
import suc from '../../commons/assets/img/suc.svg';

const useStyles = makeStyles()((theme) => {
    return {
        no_data: {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
            marginTop: '30px',
        },
        fileBox: {
            height: '40px',
            display: 'flex',
            alignItems: 'center',
            justifyContent: 'space-between',
            width: '300px',
            marginTop: '12px',
        },
    };
});

const list = [
    { name: '传输文件更新版.ppt' },
    { name: '1111.ppt' },
    { name: '22222.ppt' },
    { name: '333333.ppt' },
    { name: '444444.ppt' },
    { name: '传输文件更新版.ppt' },
    { name: 'fggggggg.ppt' },
    { name: '传输文件更新版.ppt' },
    { name: 'dddddd.ppt' },
    { name: 'zzzzzzzz.ppt' },
    { name: '传输文件更新版.ppt' },
    { name: '传输文件更新版.ppt' },
    { name: 'ddddd.ppt' },
    { name: '传输文件更新版.ppt' },
    { name: 'fffffff.ppt' },
];

export default (props) => {
    const { classes } = useStyles();

    return (
        <Grid sx={{ width: '100%' }}>
            {list.length === 0 && (
                <Grid className={classes.no_data}>
                    <img src={no_trans} alt="" />
                    <Grid sx={{ fontSize: '14px', color: '#B7B9BD' }}>
                        暂无传输任务
                    </Grid>
                </Grid>
            )}

            {list.length > 0 && (
                <Grid
                    sx={{
                        overflow: 'hidden',
                        overflowY: 'scroll',
                        height: '275px',
                        padding: '0px 18px',
                    }}
                >
                    {list.map((e, key) => {
                        return (
                            <Grid className={classes.fileBox} key={key}>
                                <Grid
                                    sx={{
                                        display: 'flex',
                                        alignItems: 'center',
                                    }}
                                >
                                    <img
                                        src={fileIcon}
                                        alt=""
                                        style={{ marginTop: '4px' }}
                                    />
                                    <Grid sx={{ marginLeft: '16px' }}>
                                        <Grid
                                            sx={{
                                                fontSize: '12px',
                                                color: '#1E2633',
                                                fontWeight: '600',
                                            }}
                                        >
                                            {e.name}
                                        </Grid>
                                        <Grid
                                            sx={{
                                                fontSize: '12px',
                                                color: '#B7B9BD',
                                            }}
                                        >
                                            下载进度：25%
                                        </Grid>
                                    </Grid>
                                </Grid>
                                <img src={suc} alt="" />
                            </Grid>
                        );
                    })}
                </Grid>
            )}
        </Grid>
    );
};
