import Controller from './controller';
import store from '../reduxs/store';
import { setRequest } from '../reduxs/actions';
class Axios {
    static async request({
        url = '',
        type = 'get',
        param = {},
        actions,
        timeout,
        isheader = true,
        noheader = false,
        fileType = false,
        other,
    }) {
        try {
            let res = await Controller.awaitAxios({
                url,
                type,
                param,
                timeout,
                isheader,
                noheader,
                fileType,
                other,
            });
            return {
                code: 200,
                status: 'success',
                res,
            };
        } catch (error) {
            actions && store.dispatch(setRequest(error));
            if (!actions) {
                return {
                    code: 40001,
                    status: 'fail',
                    error: error.response ? error.response.data : error,
                };
            }
        }
    }
}
export default Axios;
