/* eslint import/prefer-default-export: off */
import { URL } from 'url';
import path from 'path';

export function resolveHtmlPath(htmlFileName: string) {
  if (process.env.NODE_ENV === 'development') {
    const port = process.env.PORT || 1212;
    const url = new URL(`http://localhost:${port}`);
    url.pathname = htmlFileName
    let goPath  = url.href.replace('%23', '#')
    return goPath;
  }else{
    let openPath = `file://${path.resolve(__dirname, '../renderer/', htmlFileName)}`
    let src = openPath.replace(/\\/g,'/')
    return src;
  }
}
