import React, { useEffect, useState } from 'react';
import Head from '../components/head';
import { shell } from 'electron';

//js
import { getUserInfo } from '../../commons/utils/publicMethod';
import public from 'commons/public';
import Axios from '../../commons/axios/Axios';
import API from '../../commons/utils/api_manager';
import { Constants } from '../../commons/utils/constants';
import { logout, getAccountBalance } from '../../commons/utils/ajaxOption';

//ui
import { Button, Grid } from '@mui/material';
import { makeStyles } from 'tss-react/mui';
import avatar from '../../commons/assets/img/avatar.svg';

const useStyles = makeStyles()((theme) => {
    return {
        initBody: {
            display: 'flex',
            flexDirection: 'column',
            alignItems: 'center',
        },
        leftBox: {
            display: 'flex',
            alignItems: 'end',
            height: '38px',
            cursor: 'pointer',
        },
        rootButton: {
            backgroundColor: '#1370FF',
            boxShadow: 'none !important',
            color: '#ffffff',
            '&:hover': { backgroundColor: '#0055D9', transform: 'inherit' },
        },
        userBox: {
            display: 'flex',
            justifyContent: 'space-between',
            alignItems: 'center',
            width: '300px',
            marginTop: '10px',
        },
        signOutTetx: {
            fontSize: '14px',
            color: '#AAB1BD',
            cursor: 'pointer',
        },
        bar: {
            display: 'flex',
            alignContent: 'center',
            width: '300px',
            marginTop: '16px',
            marginLeft: '0px',
        },
        linebody: {
            height: '20px',
            color: '#FFFFFF',
            fontWeight: '600',
            fontSize: '11px',
            display: 'flex',
            paddingLeft: '8px',
            alignItems: 'center',
        },
        zoneList: {
            display: 'flex',
            flexWrap: 'wrap',
            width: '300px',
            marginTop: '10px',
        },
        zoneRound: {
            width: '8px',
            height: '8px',
            minWidth: '8px',
            borderRadius: '50%',
        },
        zoneLable: {
            whiteSpace: 'nowrap',
            overflow: 'hidden',
            textOverflow: 'ellipsis',
            color: '#1E2633',
            fontSize: '12px',
            marginLeft: '4px',
        },
        accountBox: {
            width: '300px',
            background: '#F4F5F7',
            borderRadius: '8px',
            padding: '16px 20px',
            marginTop: '16px',
        },
        otherTitle: {
            color: '#B7B9BD',
            fontSize: '12px',
        },
        otherValue: {
            color: '#565C66',
            marginTop: '2px',
        },
        line: {
            width: '1px',
            height: '20px',
            border: '1px solid #DDE1E6',
            margin: '0px 20px',
        },
    };
});

const zoneStorageList = [
    { id: 'ce-1', lable: '通用计算区', value: '5', color: '#1370FF' },
    {
        id: 'ce-2',
        lable: '网络增强计算区',
        value: '3',
        color: '#4AB4F8',
    },
    { id: 'ce-3', lable: 'GPU计算区', value: '2', color: '#0DD09B' },
    { id: 'ce-4', lable: 'EDA计算区', value: '2', color: '#FF9742' },
    // { id: 'ce-3', lable: 'GPU111计算区', value: '2', color: '#0DD09B' },
    // { id: 'ce-4', lable: 'EDA222计算区', value: '2', color: '#FF9742' },
    // { id: 'ce-3', lable: 'GPU22计算区', value: '2', color: '#0DD09B' },
    // { id: 'ce-4', lable: 'EDA计算区', value: '2', color: '#FF9742' },
    // { id: 'ce-3', lable: 'GPU计算区', value: '2', color: '#0DD09B' },
    // { id: 'ce-4', lable: 'EDA计算区', value: '2', color: '#FF9742' },
    // {
    //     id: 'ce-5',
    //     lable: 'roco超级无敌极限计算区',
    //     value: '1',
    //     color: '#FFB919',
    // },
];

export default (props) => {
    const { classes } = useStyles();
    const { render, navigate } = public();

    const [balanceData, setBalanceValue] = useState({});

    const getBalance = async () => {
        let data = await Axios.request(getAccountBalance());
        if (data && data.code === 200) {
            setBalanceValue(data.res.data);
        }
    };

    const sigout = async () => {
        let data = await Axios.request(logout());
        if (data && data.code === 200) {
            navigate('/');
            localStorage.removeItem(Constants.TOKEN_KEY);
            localStorage.removeItem(Constants.USER_INFO_TOKEN_KEY);
            // localStorage.removeItem(Constants.CURRENT_REGION_SELECT_KEY);
            // localStorage.removeItem(Constants.RAYSYNC_ADDR_TOKEN_KEY);
        }
    };

    console.log(getUserInfo(), 'tttttttt');

    useEffect(() => {
        getBalance();
    }, []);

    return (
        <Grid className={classes.initBody}>
            <Head level={true} />
            <Grid className={classes.userBox}>
                <Grid className={classes.leftBox}>
                    <img src={avatar} alt="" />
                    <Grid sx={{ marginLeft: '8px' }}>
                        <Grid sx={{ fontSize: '14px', color: '#1E2633' }}>
                            {getUserInfo().name}
                        </Grid>
                        <Grid sx={{ fontSize: '12px', color: '#B7B9BD' }}>
                            云空间：已用200TB
                        </Grid>
                    </Grid>
                </Grid>
                <Grid className={classes.signOutTetx} onClick={() => sigout()}>
                    退出账号
                </Grid>
            </Grid>
            <Grid
                className={classes.bar}
                container
                spacing={zoneStorageList.length}
            >
                {zoneStorageList.map((e, key) => {
                    console.log('key: ', key);
                    return (
                        <Grid
                            xs={e.value}
                            key={key}
                            className={classes.linebody}
                            sx={{
                                background: e.color,
                                // marginRight: `${-0.1 - key * 0.1}rem`,
                                // zIndex: `${100 - key}`,
                                // borderRadius: key ? '0px 4px 4px 0px' : '4px',
                            }}
                        >
                            {e.value}TB
                        </Grid>
                    );
                })}
            </Grid>
            <Grid className={classes.zoneList}>
                {zoneStorageList.map((e, key) => {
                    return (
                        <Grid
                            sx={{
                                display: 'flex',
                                alignItems: 'center',
                                width: '100px',
                            }}
                            key={key}
                        >
                            <Grid
                                className={classes.zoneRound}
                                sx={{ background: e.color }}
                            ></Grid>
                            <Grid className={classes.zoneLable}>{e.lable}</Grid>
                        </Grid>
                    );
                })}
            </Grid>
            <Grid className={classes.accountBox}>
                <Grid sx={{ fontSize: '12px', color: '#8A9099' }}>
                    账户余额
                </Grid>
                <Grid
                    sx={{
                        display: 'flex',
                        justifyContent: 'space-between',
                        marginTop: '10px',
                    }}
                >
                    <Grid sx={{ display: 'flex', alignItems: 'end' }}>
                        <Grid
                            sx={{
                                fontWeight: '600',
                                color: '#1E2633',
                                fontSize: '16px',
                                marginRight: '10px',
                            }}
                        >
                            ¥
                        </Grid>
                        <Grid
                            sx={{
                                color: '#1E2633',
                                fontSize: '30px',
                                fontWeight: '600',
                                lineHeight: '30px',
                            }}
                        >
                            {balanceData.balance}
                        </Grid>
                    </Grid>
                    <Button
                        variant="contained"
                        sx={{ width: '68px', height: '30px' }}
                        classes={{
                            root: classes.rootButton,
                        }}
                        onClick={() => {
                            let Token =
                                localStorage.getItem(Constants.TOKEN_KEY) &&
                                JSON.parse(
                                    localStorage.getItem(Constants.TOKEN_KEY)
                                );
                            shell.openExternal(
                                `http://47.57.4.97/v2/console/cloude-dashboard?access_token=${Token['access_token']}&expires_in=${Token['expires_in']}&refresh_token=${Token['refresh_token']}&recharge=true`
                            );
                        }}
                    >
                        充值
                    </Button>
                </Grid>

                <Grid
                    sx={{
                        display: 'flex',
                        marginTop: '16px',
                        alignItems: 'center',
                    }}
                >
                    <Grid
                        sx={{ display: balanceData.coupon ? 'block' : 'none' }}
                    >
                        <Grid className={classes.otherTitle}>体验金</Grid>
                        <Grid className={classes.otherValue}>
                            ¥{balanceData.coupon}
                        </Grid>
                    </Grid>
                    <Grid
                        sx={{
                            display: balanceData.creditLimit ? 'block' : 'none',
                        }}
                        className={classes.line}
                    ></Grid>
                    <Grid
                        sx={{
                            display: balanceData.creditLimit ? 'block' : 'none',
                        }}
                    >
                        <Grid className={classes.otherTitle}>信用额度</Grid>
                        <Grid className={classes.otherValue}>
                            ¥{balanceData.creditLimit}
                        </Grid>
                    </Grid>
                    <Grid
                        sx={{
                            display: balanceData.daysLimit ? 'block' : 'none',
                        }}
                        className={classes.line}
                    ></Grid>
                    <Grid
                        sx={{
                            display: balanceData.daysLimit ? 'block' : 'none',
                        }}
                    >
                        <Grid className={classes.otherTitle}>可透支天数</Grid>
                        <Grid className={classes.otherValue}>
                            {balanceData.daysLimit}天
                        </Grid>
                    </Grid>
                </Grid>
            </Grid>
        </Grid>
    );
};
