import * as React from "react";
import { ReactNode, useEffect } from "react";
import Box from "@mui/material/Box";
import ButtonComponent from "./Button";
import tipsIcon from "@/assets/project/information-outline.svg";
import Popper from "@mui/material/Popper";

type IMyPopconfirmProps = {
  title: string | ReactNode;
  cancelText?: string;
  okText?: string;
  showCancel?: boolean;
  onCancel?: any;
  onConfirm?: any;
  children: ReactNode;
};

const MyPopconfirm = (props: IMyPopconfirmProps) => {
  const {
    title,
    cancelText = "取消",
    okText = "确认",
    showCancel = true,
    onCancel,
    onConfirm,
  } = props;

  const [anchorEl, setAnchorEl] = React.useState<null | HTMLElement>(null);

  const handleClick = (event: React.MouseEvent<HTMLElement>) => {
    event.nativeEvent.stopImmediatePropagation();
    setAnchorEl(anchorEl ? null : event.currentTarget);
  };

  const open = Boolean(anchorEl);
  const id = open ? "simple-popper" : undefined;

  const handleCancel = () => {
    setAnchorEl(null);
    onCancel && onCancel();
  };

  const handleOk = () => {
    setAnchorEl(null);
    onConfirm && onConfirm();
  };

  useEffect(() => {
    document.addEventListener("click", (e) => {
      setAnchorEl(null);
    });
  }, []);

  return (
    <div>
      <div aria-describedby={id} onClick={handleClick}>
        {props.children && props.children}
      </div>
      <Popper
        id={id}
        open={open}
        anchorEl={anchorEl}
        sx={{
          zIndex: 2000,
          bgcolor: "#fff",
          minWidth: "200px",
          borderRadius: "2px",
          padding: "20px 16px",
          boxShadow: "0px 3px 10px 0px rgba(0, 24, 57, 0.14)",
        }}
      >
        {/* "0 3px 6px -4px #0000001f, 0 6px 16px #00000014, 0 9px 28px 8px #0000000d", */}
        <Box sx={{ marginBottom: "16px" }}>
          <img
            style={{ marginRight: "12px", position: "relative", top: "3px" }}
            src={tipsIcon}
            alt=""
          />
          {title}
        </Box>
        <Box sx={{ display: "flex", justifyContent: "flex-end" }}>
          {showCancel && (
            <ButtonComponent
              text={cancelText}
              // variant="text"
              size="small"
              color="inherit"
              click={handleCancel}
              style={{ marginRight: "12px" }}
            ></ButtonComponent>
          )}
          <ButtonComponent
            text={okText}
            // variant="text"
            size="small"
            click={handleOk}
          ></ButtonComponent>
        </Box>
      </Popper>
    </div>
  );
};

export default MyPopconfirm;
