import React, { useImperativeHandle, useMemo } from "react";

import MyDialog from "@/components/mui/MyDialog";
import { useMessage } from "@/components/MySnackbar";
import CloudEController from "@/api/fileserver/CloudEController";
import { getDataFileDel, getDataFileDelPackage } from "@/api/project_api";
import useMyRequest from "@/hooks/useMyRequest";

const DeleteDialog = (props: any) => {
	const {
		path,
		projectId,
		fileToken,
		currentOperateFile,
		selectIds,
		refresh,
		showList,
	} = props;
	const Message = useMessage();
	let deleteFileDialogRef: any = React.createRef();
	const showDialog = () => {
		deleteFileDialogRef.current.handleClickOpen();
	};

	useImperativeHandle(props.onRef, () => {
		return {
			showDialog: showDialog,
		};
	});
	const { run: getDataFileDelRun } = useMyRequest(getDataFileDel, {
		onSuccess: (res: any) => {
			successDelete();
		},
	});

	const { run: getDataFileDelPackageRun } = useMyRequest(
		getDataFileDelPackage,
		{
			onSuccess: (res: any) => {
				successDelete();
			},
		}
	);

	const successDelete = () => {
		Message.success("删除成功！");
		deleteFileDialogRef?.current?.handleClose();
		refresh();
	};

	const deletePathProvidedToDataSet = useMemo(() => {
		return path === "/" ? "/" : `${path}/`;
	}, [path]);

	const deletePathProvidedFileServer = useMemo(() => {
		return path === "/" ? `${path}` : `${path}/`;
	}, [path]);

	// 删除
	const handleSubmit = () => {
		if (!currentOperateFile) {
			// 批量删除
			// 要删除的数据集
			const datSetDeleteList = showList.filter((item: any) => {
				return selectIds.indexOf(item.name) !== -1 && item.type === "dataSet";
			});
			// 要删除的文件夹
			const folderDeleteList = showList.filter((item: any) => {
				return selectIds.indexOf(item.name) !== -1 && item.type === "directory";
			});
			// 要删除的文件
			const fileDeleteList = showList.filter((item: any) => {
				return (
					selectIds.indexOf(item.name) !== -1 &&
					item.type !== "dataSet" &&
					item.type !== "directory"
				);
			});
			if (datSetDeleteList.length > 0) {
				dataSetsDelete(datSetDeleteList);
			}
			if (folderDeleteList.length > 0) {
				foldersDelete(folderDeleteList);
			}
			if (fileDeleteList.length > 0) {
				filesDelete(fileDeleteList);
			}
		} else {
			if (currentOperateFile.type === "dataSet") {
				dataSetDelete();
			} else if (currentOperateFile.type === "directory") {
				folerDelete();
			} else {
				fileDelete();
			}
		}
	};

	// 删除单个数据集
	const dataSetDelete = () => {
		getDataFileDelRun({
			projectId: projectId as string,
			names: currentOperateFile.name,
			path: deletePathProvidedToDataSet,
		});
	};

	// 删除单个文件夹
	const folerDelete = () => {
		fileDelete();
		const names = currentOperateFile.name;
		dataSetInFolerDelete(names);
	};

	// 删除文件夹中的数据集
	const dataSetInFolerDelete = (names: string) => {
		getDataFileDelPackageRun({
			projectId: projectId as string,
			names,
			path: deletePathProvidedToDataSet,
		});
	};

	// 删除单个文件
	const fileDelete = () => {
		CloudEController.JobOutFileDel(
			`${deletePathProvidedFileServer}${currentOperateFile.name}`,
			fileToken as string,
			projectId as string
		)?.then((res) => {
			successDelete();
		});
	};

	// 删除多个数据集
	const dataSetsDelete = (datSetDeleteList: Array<any>) => {
		getDataFileDelRun({
			projectId: projectId as string,
			names: datSetDeleteList.map((item: any) => item.name).join(","),
			path: deletePathProvidedToDataSet,
		});
	};

	// 删除多个文件夹
	const foldersDelete = (folderDeleteList: Array<any>) => {
		filesDelete(folderDeleteList);
		const names = folderDeleteList.map((item: any) => item.name).join(",");
		dataSetInFolerDelete(names);
	};

	// 删除多个文件
	const filesDelete = (fileDeleteList: Array<any>) => {
		const deletePath = fileDeleteList
			.map((item: any) => {
				return `${deletePathProvidedFileServer}${item.name}`;
			})
			.join(" ");
		CloudEController.JobOutFileDel(
			deletePath,
			fileToken as string,
			projectId as string
		)?.then((res) => {
			successDelete();
		});
	};

	const submitloading = false;

	return (
		<MyDialog
			handleSubmit={handleSubmit}
			onRef={deleteFileDialogRef}
			title="提示"
			submitloading={submitloading}
		>
			{currentOperateFile
				? "确认删除该数据吗？"
				: `确认删除这${selectIds.length}条数据吗？`}
		</MyDialog>
	);
};

export default DeleteDialog;
