/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-05 14:00:37
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-08-03 14:05:58
 * @FilePath: /bkunyun/src/components/mui/MyInput.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import TextField, { TextFieldProps } from "@mui/material/TextField";
import { ThemeProvider, createTheme } from "@mui/material/styles";

interface MyInputProps extends Omit<TextFieldProps, "value"> {
	value?: string;
	variant?: "standard" | "filled" | "outlined";
	size?: "small" | "medium";
	placeholder?: string;
	fullWidth?: boolean; // 宽度是否和容器一致
	error?: boolean;
}

const MyInput = (props: MyInputProps) => {
	const {
		size = "medium",
		placeholder = "请输入",
		fullWidth = true,
		error = false,
		label,
		...other
	} = props;

	const theme = createTheme({
		components: {
			MuiInputBase: {
				styleOverrides: {
					root: {
						height: "36px",
						fontSize: "14px",
						border: "rgba(221, 225, 230, 1)",
						padding: "7px 12px",
						"&.MuiInputBase-sizeSmall": {
							height: "32px",
						},
						"&.Mui-disabled": {
							background: "rgba(247, 248, 250, 1)",
							cursor: "not-allowed",
							"& .MuiOutlinedInput-notchedOutline": {
								borderColor: "#DDE1E6",
							},
						},
					},
					multiline: {
						height: "auto",
						textarea: {
							padding: 0,
						},
					},
					input: {
						"&.Mui-disabled": {
							background: "rgba(247, 248, 250, 1)",
							cursor: "not-allowed",
						},
					},
				},
			},
			MuiInputLabel: {
				styleOverrides: {
					root: {
						top: "-9px",
						fontSize: "14px",
					},
					shrink: {
						top: 0,
					},
					sizeSmall: {
						top: "-5px",
					},
				},
			},
			MuiOutlinedInput: {
				styleOverrides: {
					root: {
						padding: "7px 12px",
						"&.Mui-focused .MuiOutlinedInput-notchedOutline": {
							borderWidth: "1px",
						},
						"& .MuiOutlinedInput-notchedOutline": {
							borderColor: "#DDE1E6",
						},
						"&.Mui-disabled": {
							background: "rgba(247, 248, 250, 1)",
							cursor: "not-allowed",
							"& .MuiOutlinedInput-notchedOutline": {
								borderColor: "#DDE1E6",
							},
						},
						":hover": {
							"& .MuiOutlinedInput-notchedOutline": error
								? {}
								: {
										borderColor: "#1370ff",
								  },
							"&.Mui-disabled": {
								background: "rgba(247, 248, 250, 1)",
								cursor: "not-allowed",
								"& .MuiOutlinedInput-notchedOutline": {
									borderColor: "#DDE1E6",
								},
							},
						},
					},
					input: {
						padding: "0",
						verticalAlign: "middle",
					},
				},
			},
			MuiTypography: {
				styleOverrides: {
					root: {
						marginRight: "-5px",
					},
				},
			},
		},
	});

	return (
		<ThemeProvider theme={theme}>
			<TextField
				error={error}
				size={size}
				placeholder={placeholder}
				fullWidth={fullWidth}
				label={label}
				{...other}
			/>
		</ThemeProvider>
	);
};

export default MyInput;
