// 分页组件
import Pagination from "@mui/material/Pagination";
import { ThemeProvider, createTheme } from "@mui/material/styles";
const theme = createTheme({
	components: {
		MuiPagination: {
			styleOverrides: {
				ul: {
					flexWrap: "nowrap",
				},
			},
		},
		MuiPaginationItem: {
			styleOverrides: {
				root: {
					"&.Mui-selected": {
						background: "rgba(19, 112, 255, 1)",
						color: "#fff",
						":hover": {
							background: "rgba(19, 112, 255, 1)",
							color: "#fff",
						},
					},
				},
			},
		},
	},
});

type IMyPaginationProps = {
	page: number;
	pageChange: any;
	count: number;
};

const MyPagination = (props: IMyPaginationProps) => {
	const { page, pageChange, count } = props;

	const handlePageChange = (e: any, value: number) => {
		pageChange && pageChange(value);
	};
	return (
		<ThemeProvider theme={theme}>
			<Pagination
				page={page + 1} // 请求接口的页码是从0开始的
				count={count + 1}
				shape="rounded"
				onChange={handlePageChange}
				// sx={{
				// 	padding: "20px 0",
				// 	display: "flex",
				// 	justifyContent: "flex-end",
				// }}
			/>
		</ThemeProvider>
	);
};

export default MyPagination;
