import MyTableDemo from "./MyTableDemo";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import { useCallback, useMemo, useState } from "react";
import styles from "./index.module.css";

const Demo = () => {
	const demoList = useCallback(() => {
		return [
			{
				name: "表格",
				element: MyTableDemo,
			},
			{
				name: "box",
				element: () => {
					return <div>box</div>;
				},
			},
		];
	}, []);

	const radioOptionsArr = [
		{
			value: "表格",
			label: "表格",
		},
		{
			value: "box",
			label: "box",
		},
	];
	const handleRadio = (e: string) => {
		setSelectDemo(e);
	};
	const [selectDemo, setSelectDemo] = useState("表格");
	const randerDemo = useMemo(() => {
		return demoList().filter((item) => item.name === selectDemo)[0].element;
	}, [selectDemo, demoList]);

	return (
		<div className={styles.demoBox}>
			<RadioGroupOfButtonStyle
				value={selectDemo}
				radioOptions={radioOptionsArr}
				handleRadio={handleRadio}
			/>
			<div className={styles.demoContentBox}>{randerDemo()}</div>
		</div>
	);
};

export default Demo;
