/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-05 14:00:37
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-06 11:45:10
 * @FilePath: /bkunyun/src/components/mui/MyInput.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import TextField, { TextFieldProps } from "@mui/material/TextField";

interface MyInputProps extends Omit<TextFieldProps, "value"> {
	value?: any;
	inputSx?: any;
	onChange?: any;
	onFocus?: any;
	label?: string;
	variant?: "standard" | "filled" | "outlined";
	id?: string;
	size?: "small" | "medium";
	placeholder?: string;
	fullWidth?: boolean; // 宽度是否和容器一致
	InputProps?: any; // input加前后icon可以用这个
	error?: boolean;
	helperText?: string;
}

const MyInput = (props: MyInputProps) => {
	const {
		inputSx = {},
		value,
		onChange,
		onFocus,
		label,
		id,
		variant,
		size = "small",
		placeholder = "请输入",
		fullWidth = true,
		InputProps,
		error = false,
		helperText,
		disabled,
	} = props;

	return (
		<TextField
			{...props}
			error={error}
			helperText={helperText}
			sx={{ ...inputSx }}
			id={id}
			label={label}
			variant={variant}
			onChange={onChange}
			onFocus={onFocus}
			size={size}
			placeholder={placeholder}
			fullWidth={fullWidth}
			InputProps={{
				...InputProps,
			}}
			disabled={disabled}
			value={value}
		/>
	);
};

export default MyInput;
