/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-12 11:51:17
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/interface.ts
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
type IType = "BATCH" | "FLOW";
export interface IParameter {
  hidden: boolean;
  id?: string;
  name: string;
  required: boolean;
  defaultValue: any;
  domType: IDomType;
  classType: string;
  classTypeName: string;
  value: any;
  description: string;
  language: string;
  languageVersion: string;
  tags: Array<string>;
  source: string;
  productId: string;
  // tasks: ITask[];
  linked?: boolean;
  validators: Array<IValidator>;
  choices: Array<IChoice>;
  error?: boolean;
  helperText?: string;
  parameterGroup?: string;
}

export type IExecutionStatus = "Pending" | "Running" | "Done" | "Failed";

export interface ITask {
  id: string;
  title: string;
  description: string;
  version?: string;
  allVersions?: string[]
  position: {
    x: number;
    y: number;
  };
  tags?: string[];
  type: IType | string;
  parentNode?: string;
  parameters: Array<IParameter>;
  edges: Array<IEdge>;
  isCheck?: boolean;
  executionStatus?: IExecutionStatus;
}

export interface ITemplateConfig {
  title: string;
  version: string;
  updateTime?: string;
  description: string;
  language: string;
  languageVersion: string;
  tags: Array<string>;
  source: string;
  productId: string;
  tasks: ITask[];
  id: string;
}

export type IDomType =
  | "path"
  | "dataset"
  | "file"
  | "input"
  | "select"
  | "multipleselect"
  | "radio"
  | "checkbox";

// 待定
export type IValidator = {
  regex: string;
  message: string;
};

export interface IChoice {
  label: string;
  value: boolean | string | number;
}

export interface IEdge {
  id: string;
  source: string;
  sourceHandle: string;
  target: string;
  targetHandle: string;
  label?: string;
}

// 提交任务时的动态表单的数据结构
export type IRenderTasks = Array<IRenderTask>;
export type IRenderTask = {
  id: string;
  title: string;
  description: string;
  position: {
    x: number;
    y: number;
  };
  type: IType | string;
  parameters: Array<IParameter>;
  edges: Array<IEdge>;
  flows: ITask[];
  isCheck: boolean; // 里面的子项表单校验是否全部通过
};

export interface ITaskInfo extends ITemplateConfig {
  name: string;
  outputPath: string;
  state: IState;
  specTitle: string;
  specVersion: string;
  jobCost: string;
  creator: string;
  createTime: string;
  costTime: string;
  logPath: string;
  outputs?: any;
}

type IState = "SUCCEEDED" | "RUNNING" | "ABORTED" | "FAILED";
