import { memo, useCallback, useEffect, useMemo, useState } from "react";
import styles from "../index.module.css";
import { Box, Typography } from "@mui/material";
import Button from "@/components/mui/Button";
import Dialog from "@/components/mui/MyDialog";
import OutlinedInput from "@mui/material/OutlinedInput";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import SearchIcon from "@mui/icons-material/Search";
import Checkbox from "@mui/material/Checkbox";
import CloseOutlinedIcon from "@mui/icons-material/CloseOutlined";
import noData from "../../../../../assets/project/noTemplate.svg";
import _ from "lodash";

const AddTemplate = (props: any) => {
	const {
		openAddTemplate,
		closeAddTemplateBlock,
		addTemplateList,
		templateSelectCallback,
		selectTemplateData,
		addTemplateCallback,
		searchTemplateNameCallback,
	} = props;

	const [templateType, setTemplateType] = useState("public");
	const radioOptions = [
		{
			value: "public",
			label: "公共",
		},
		{
			value: "custom",
			label: "自定义",
		},
	];

	const handleRadio = (value: string) => {
		setTemplateType(value);
	};

	return (
		<Box
			className={styles.addTemplateMask}
			sx={{ display: openAddTemplate ? "flex" : "none" }}
		>
			<Box sx={{ height: "50px", display: "flex", alignItems: "center" }}>
				<CloseOutlinedIcon
					sx={{ color: "#ffffff", marginRight: "10px", cursor: "pointer" }}
					onClick={() => {
						closeAddTemplateBlock();
					}}
				/>
			</Box>
			<Box className={styles.addTemplateBlock}>
				<Box sx={{ padding: "24px 32px" }}>
					<Typography
						sx={{ fontSize: "18px", fontWeight: "600", color: "#1E2633" }}
					>
						添加工作流模版
					</Typography>
					<Box
						sx={{
							display: "flex",
							justifyContent: "space-between",
							alignItems: "center",
							marginBottom: "20px",
						}}
					>
						<OutlinedInput
							onChange={(e: any) => {
								_.debounce(() => {
									searchTemplateNameCallback(e.target.value);
								}, 200)();
							}}
							placeholder="输入关键词搜索"
							size="small"
							sx={{ width: 340, height: 32, marginTop: "20px" }}
							endAdornment={<SearchIcon style={{ color: "#8A9099" }} />}
						/>
						<Box
							sx={{
								display: "flex",
								justifyContent: "flex-end",
								alignItems: "center",
							}}
						>
							<RadioGroupOfButtonStyle
								value={templateType}
								radioOptions={radioOptions}
								handleRadio={handleRadio}
							></RadioGroupOfButtonStyle>
							<Button
								click={addTemplateCallback}
								size={"small"}
								style={{
									marginLeft: "12px",
								}}
								text={
									"添加模版" +
									(selectTemplateData.length === 0
										? ""
										: `(${selectTemplateData.length})`)
								}
							/>
						</Box>
					</Box>

					{addTemplateList.length === 0 && (
						<Box
							sx={{
								display: "flex",
								alignItems: "center",
								flexDirection: "column",
								minHeight: "calc(100vh - 376px)",
								justifyContent: "center",
							}}
						>
							<img alt="" src={noData} />
							<Typography
								sx={{ fontSize: "12px", fontWeight: "400", color: "#8A9099" }}
							>
								暂无相关模版
							</Typography>
						</Box>
					)}

					<Box
						sx={{
							display: "flex",
							flexWrap: "wrap",
							overflowX: "hidden",
							overflowY: "overlay",
							marginLeft: "-8px",
						}}
					>
						{addTemplateList.map((item: any, key: any) => {
							return (
								<Box
									className={styles.addTemplateBox}
									onClick={() => {
										templateSelectCallback(item.id);
									}}
									sx={{
										border: selectTemplateData.includes(item.id)
											? "1px solid #1370FF"
											: "1px solid #EBEDF0;",
									}}
									key={item.id}
								>
									<Box
										sx={{
											display: "flex",
											justifyContent: "space-between",
											alignItems: "center",
										}}
									>
										<Typography
											sx={{
												fontSize: "14px",
												fontWeight: "600",
												color: "#1E2633",
												marginBottom: "4px",
												overflow: "hidden",
												textOverflow: "ellipsis",
											}}
										>
											{item.title}
										</Typography>
										<Checkbox
											size="small"
											sx={{ padding: "0px" }}
											checked={selectTemplateData.includes(item.id)}
										/>
									</Box>
									<Box sx={{ display: "flex", marginBottom: "8px" }}>
										<Typography
											sx={{
												fontSize: "12px",
												fontWeight: "400",
												color: "#1370FF",
												marginRight: "24px",
											}}
										>
											版本：{item.version}
										</Typography>
										<Typography
											sx={{
												fontSize: "12px",
												fontWeight: "400",
												color: "#1370FF",
											}}
										>
											更新时间：{item.updateTime}
										</Typography>
									</Box>
									<Typography className={styles.templateDescText}>
										{item.description}
									</Typography>
								</Box>
							);
						})}
					</Box>
				</Box>
			</Box>
		</Box>
	);
};

export default memo(AddTemplate);
