/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-12 11:20:29
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-15 10:48:22
 * @FilePath: /bkunyun/src/views/Project/components/Flow/components/BatchNode.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */

import { Tooltip } from "@mui/material";
import classNames from "classnames";
import { useMemo } from "react";
import { Handle, Position } from "react-flow-renderer";

import { uuid } from "@/utils/util";
import { IBatchNode } from "../../interface";

import styles from "./index.module.css";

/** 自定义batch节点 */
const BatchNode = (props: IBatchNode) => {
	const { data } = props;
	const {
		style,
		isFlowNode,
		selectedStatus,
		info: { title, isCheck, executionStatus, parameters },
		flowType,
	} = data;
	/** 获取输入参数数组 */
	const inParamsArr = useMemo(() => {
		return (
			(parameters?.length &&
				parameters?.filter((item) => {
					return item.parameterGroup === "in";
				})) ||
			[]
		);
	}, [parameters]);

	/** 获取输出参数数组 */
	const outParamsArr = useMemo(() => {
		return (
			(parameters?.length &&
				parameters?.filter((item) => {
					return item.parameterGroup === "out";
				})) ||
			[]
		);
	}, [parameters]);

	return (
		<div
			className={classNames({
				[styles.batchNode]: true,
				[styles.selectedBatchBox]: selectedStatus,
				[styles.runBatchNode]: executionStatus === "Running",
				[styles.doneBatchNode]: executionStatus === "Done",
				[styles.errorBatchNode]: executionStatus === "Failed",
			})}
			style={style}
		>
			{inParamsArr?.length
				? inParamsArr.map((item, index) => {
						return (
							<Tooltip title={item.name} key={uuid()}>
								<Handle
									id={item.name}
									style={{
										background: "#fff ",
										border: item.error
											? "1px solid #FF4E4E"
											: "1px solid #D1D6DE",
										left: index * 20 + 20,
									}}
									type="target"
									position={Position.Top}
								/>
							</Tooltip>
						);
				  })
				: null}
			<div
				className={classNames({
					[styles.batchRotate]: isFlowNode,
				})}
			>
				{title || ""}
				{isCheck && flowType !== "edit" ? (
					<span className={styles.successDot}></span>
				) : null}
			</div>
			{outParamsArr?.length
				? outParamsArr.map((item, index) => {
						return (
							<Tooltip title={item.name} key={uuid()}>
								<Handle
									id={item.name}
									style={{
										background: "#fff ",
										border: "1px solid #D1D6DE",
										left: index * 20 + 20,
									}}
									type="source"
									position={Position.Bottom}
								/>
							</Tooltip>
						);
				  })
				: null}
		</div>
	);
};

export default BatchNode;
