import { IParameter } from "../Project/ProjectSubmitWork/interface";
export const getCustomTemplateParameterCheckResult = (
  parameter: IParameter,
): {
  error: boolean;
  helperText: string;
  deleteLine?: boolean; // 该线是否要删除
} => {
  let error = false;
  let helperText = "";
  // 输出不做校验
  if (parameter.parameterGroup === "out") {
    return {
      error,
      helperText,
    }
  }
  // 输入校验
  // 1. 当该输入为必填项时：
  
  // 1.1 若为“启用”状态，则表示该输入的值交由用户在使用时填写。故该输入的节点入口在右侧编辑区内不允许连线，若已有连线则自动将该线删除。
  
  // 1.2 若为“关闭”状态，则表示该输入的值是上一步批算子的结果。故该输入的节点入口在右侧编辑区内必须有连线。（若编辑者没有为该节点入口添加连线，则错误提示“该输入为必填，需在右侧视图编辑区连接输入文件或重新改回“开启”状态”；若连上线了则无需错误提示。）
  
  // 2. 当该输入为选填项时：
  
  // 2.1 若为“启用”状态，则表示该输入的值交由用户在使用时填写。故该输入的节点入口在右侧编辑区内不允许连线，若已有连线则自动将该线删除。
  
  // 2.2 若为“关闭”状态，则表示该输入的值是上一步批算子的结果，又因为其为选填项，所以这线可连可不连，不做限制。
  if (parameter.parameterGroup === "in") {
    if (parameter.required) {
      if (!parameter.hidden && parameter.linked) {
        return {
          error,
          helperText,
          deleteLine: true,
        }
      } else if (!parameter.hidden && !parameter.linked) {
        return {
          error,
          helperText,
          deleteLine: false,
        }
      } else if (parameter.hidden && parameter.linked) {
        return {
          error,
          helperText,
          deleteLine: false,
        }
      } else if (parameter.hidden && !parameter.linked) {
        return {
          error: true,
          helperText: '该输入为必填，需在右侧视图编辑区连接输入文件或重新改回“开启”状态',
          deleteLine: false,
        }
      }
    } else {
      if (!parameter.hidden && parameter.linked) {
        return {
          error,
          helperText,
          deleteLine: true,
        }
      } else if (!parameter.hidden && !parameter.linked) {
        return {
          error,
          helperText,
          deleteLine: false,
        }
      } else if (parameter.hidden && parameter.linked) {
        return {
          error,
          helperText,
          deleteLine: false,
        }
      } else if (parameter.hidden && !parameter.linked) {
        return {
          error,
          helperText,
          deleteLine: false,
        }
      }
    }
  }
  // 表单校验
  if (parameter.required) {
    // 提交任务时不展示
    if (parameter.hidden) {
      if (Array.isArray(parameter.defaultValue)) {
        if (parameter.defaultValue.length === 0) {
          error = true;
          helperText = "该参数为必填，您必须为该参数赋予默认值";
        }
      } else if (parameter.defaultValue === "" || parameter.defaultValue === null || parameter.defaultValue === undefined) {
        error = true;
        helperText = "该参数为必填，您必须为该参数赋予默认值";
      }
    }
  }
  if (error) {
    return {
      error,
      helperText,
    };
  }
  // linked
  // 有值才做validators旋律校验
  if (parameter.defaultValue) {
    if (Array.isArray(parameter.validators)) {
      if (parameter.validators.length > 0) {
        parameter.validators.forEach((validator) => {
          const reg = new RegExp(validator.regex);
          if (!reg.test(parameter.defaultValue)) {
            error = true;
            helperText = validator.message;
          }
        });
      }
    }
  }
  return {
    error,
    helperText,
  };
};
