import React from 'react';
import FormControlLabel from '@material-ui/core/FormControlLabel';
import { Radio } from "@material-ui/core";
import Checkbox from '@material-ui/core/Checkbox';
import PropTypes from "prop-types";
import makeStyles from "@material-ui/styles/makeStyles";
const useStyles = makeStyles({
    label: { color: "#383838", fontSize: "14px" },
    root: { marginRight: 0 },
    radioRoot: { color: "#c9c9c9" },
    radioChecked: { color: "#136EFA !important" },
})
const CheckBoxComponent = props => {
    const { defaultChecked = false, checkChange, label, color, id, checkBoxStyle = {}, size, disabled, labelPlacement, controllChecked, controllCheckChange, controll, radio, show = true } = props;
    const [checked, setChecked] = React.useState(defaultChecked);
    const classes = useStyles()
    const handleChange = (event) => {
        setChecked(event.target.checked);
        checkChange && checkChange(event.target.checked)
    };

    const controllHandleChange = (event) => {
        controllCheckChange(event.target.checked)
    };

    if (!show) return ""
    if (controll) {
        return (
            <FormControlLabel
                control={
                    radio ?
                        <Radio size={'small'}
                            classes={{ root: classes.radioRoot, checked: classes.radioChecked }}
                            checked={controllChecked} onChange={controllHandleChange} /> :
                        <Checkbox
                            checked={controllChecked}
                            onChange={controllHandleChange}
                            name={id || "name"}
                            color={color || "primary"}
                            disabled={disabled || false}
                            size={size || "medium"}
                        />
                }
                label={label || ""}
                labelPlacement={labelPlacement || "end"}
                classes={{
                    label: checkBoxStyle.label || classes.label,
                    root: checkBoxStyle.root || classes.root,
                }}
            />
        )
    }
    return (
        <FormControlLabel
            control={
                <Checkbox
                    checked={checked}
                    onChange={handleChange}
                    name={id || "name"}
                    color={color || "primary"}
                    disabled={disabled || false}
                    size={size || "medium"}
                />
            }
            label={label || ""}
            labelPlacement={labelPlacement || "end"}
            classes={{
                label: checkBoxStyle.label || classes.label,
                root: checkBoxStyle.root || classes.root,
            }}
        />
    )
}

CheckBoxComponent.propTypes = {
    size: PropTypes.oneOf(["medium", "small"]),
    disabled: PropTypes.oneOf([true, false]),
};

export default CheckBoxComponent