import { useState, useCallback, useEffect, useMemo } from "react";
import classnames from "classnames";
import style from "./index.module.css";
import CloseIcon from "@mui/icons-material/Close";
import MyButton from "@/components/mui/MyButton";
import InsertDriveFileOutlinedIcon from "@mui/icons-material/InsertDriveFileOutlined";
import CloudEController from "@/api/fileserver/CloudEController";
import { useStores } from "@/store";
import { toJS } from "mobx";


type LogViewProps = {
    isshow: boolean;
    handleClose: () => void;
    logs: any[];
};

const LogView = (props: LogViewProps) => {
    const { isshow, handleClose, logs } = props;
    const { currentProjectStore } = useStores();
    const fileToken = toJS(currentProjectStore.currentProjectInfo.filetoken);
    const projectId = toJS(currentProjectStore.currentProjectInfo.id);
    // 当前选择的日志
    const [logCurrent, setLogCurrent] = useState<number>(0);
    // 当前日志的内容文本
    const [logText, setLogText] = useState('')
    // 当前日志路径
    const [logPath, setLogPath] = useState('')

    useEffect(() => {
        setLogPath(logs[logCurrent]?.logPath)
    }, [logs]);

    // 请求日志文本
    useEffect(() => {
        if (logPath) {
            const path = logPath.slice(12)
            CloudEController.JobFileDownloadText(
                path,
                fileToken as string,
                projectId as string
            )?.then((res) => {
                setLogText(res.data)
            })
        }else{
            setLogText("")
        }
    }, [logPath]);

    // 选择日志时改变日志路径
    useEffect(() => {
        setLogPath(logs[logCurrent]?.logPath)
    }, [logCurrent]);

    // 下载当前日志
    const handleDownLoad=()=>{
        const path = logPath.slice(12)
        CloudEController.JobFileDownload(
			path,
			fileToken as string,
			projectId as string
		);
    }

    return <div className={style.logView} style={isshow ? {} : { display: "none" }}>
        <div className={style.logViewBox}>
            <CloseIcon onClick={handleClose} className={style.close} />
            <div className={style.logViewContentMask}></div>
            <div className={style.logViewTop}>
                {logs.map((item: any, index: number) => {
                    return <div
                        key={index}
                        onClick={() => { setLogCurrent(index) }}
                        className={classnames({
                            [style.logTitle]: true,
                            [style.logTitleSelected]: index === logCurrent,
                        })}>
                        <InsertDriveFileOutlinedIcon className={style.fileIcon} />
                        <span>{item.logName}</span>
                    </div>
                })}
            </div>
            <div className={style.logViewContent}>
                {logText}
            </div>
            <div className={style.logViewBottom}>
                <MyButton text='下载当前日志' onClick={handleDownLoad} />
            </div>
        </div>
    </div>
}

export default LogView