import { memo } from "react";
import { Box, Typography } from "@mui/material";
import Dialog from "@/components/mui/Dialog";

const SimpleDialog = (props: any) => {
	const { openDialog, closeDialog, onConfirm, text, title } = props;

	return (
		<>
			<Dialog
				open={openDialog}
				onClose={closeDialog}
				onConfirm={onConfirm}
				title={title}
			>
				<Box>
					<Typography sx={{ fontSize: "14px", fontWeight: "400" }}>
						{text}
					</Typography>
				</Box>
			</Dialog>
		</>
	);
};

export default memo(SimpleDialog);
