/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-12 11:29:46
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-12 21:06:48
 * @FilePath: /bkunyun/src/views/Project/components/Flow/components/FlowNode/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import classNames from "classnames";
import { Handle, Position } from "react-flow-renderer";

import { IExecutionStatus } from "@/views/Project/ProjectSubmitWork/interface";
import jobFail from "@/assets/project/jobFail.svg";
import jobRun from "@/assets/project/jobRun.svg";
import jobSue from "@/assets/project/jobSue.svg";

import styles from "./index.module.css";
/** 自定义flow节点 */
const FlowNode = (props: any) => {
	/** 获取imgUrl */
	const getImgUrl = (type: IExecutionStatus) => {
		if (type === "Done") {
			return jobSue;
		}
		if (type === "Failed") {
			return jobFail;
		}
		if (type === "Running") {
			return jobRun;
		}
		return undefined;
	};

	const { data } = props;
	const {
		dotStatus,
		selectedStatus,
		info: { title, isCheck, executionStatus },
	} = data;
	return (
		<div
			className={classNames({
				[styles.flowNode]: true,
				[styles.selectedFlowBox]: selectedStatus,
			})}
		>
			{dotStatus?.isInput ? (
				<Handle
					style={{ background: "#C2C6CC ", left: 12 }}
					type="target"
					position={Position.Top}
				/>
			) : null}
			<div style={{ display: "flex", alignItems: "center" }}>
				{title || ""}
				{isCheck && <span className={styles.successDot}></span>}
				{getImgUrl(executionStatus) && (
					<img
						style={{ marginLeft: "6px" }}
						src={getImgUrl(executionStatus)}
						alt=""
					/>
				)}
			</div>
			{dotStatus?.isOutput ? (
				<Handle
					style={{ background: "#C2C6CC ", left: 12 }}
					type="source"
					position={Position.Bottom}
				/>
			) : null}
		</div>
	);
};

export default FlowNode;
