import styles from "./index.module.css";
import {
	ITask,
	IParameter,
} from "../../../Project/ProjectSubmitWork/interface";
import noTemplate from "@/assets/project/noTemplate.svg";
import { useCallback, useEffect, useMemo, useState } from "react";
import MyInput from "@/components/mui/MyInput";
import Tooltip from "@mui/material/Tooltip";
import MyCheckBox from "@/components/mui/MyCheckBox";
// import MySelect, { optionsTransform } from "../components/MySelect";
import MySelect, {
	optionsTransform,
} from "../../../Project/ProjectSubmitWork/components/MySelect";
import _ from "lodash";
import FileSelect from "@/components/FileSelect";
import MyRadio from "@/components/mui/MyRadio";
import questionMark from "@/assets/project/questionMark.svg";
import fileSelectIcon from "@/assets/project/fileSelect.svg";
import MySwitch from "@/components/mui/MySwitch";
import Tabs from "@/components/mui/Tabs";
import classNames from "classnames";
import { getCustomTemplateParameterCheckResult } from "../../util";

type IParameterSettingProps = {
	templateConfigInfo: ITask[];
	taskId: string;
	setTemplateConfigInfo: any;
};

// const templateConfigInfoMock = [
// 	{
// 		id: "id",
// 		title: "title",
// 		description:
// 			"阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段阿斯蒂芬吉林集安拉开圣诞节疯狂拉升阶段",
// 		version: "version",
// 		position: {
// 			x: 10,
// 			y: 100,
// 		},
// 		tags: ["string[]"],
// 		type: "BATCH",
// 		parentNode: "string",
// 		parameters: [
// 			{
// 				hidden: true,
// 				id: "1",
// 				name: "smi_in",
// 				required: true,
// 				defaultValue: "",
// 				domType: "input",
// 				classType: "STRING",
// 				classTypeName: "String",
// 				value: "",
// 				description: "123",
// 				language: "",
// 				languageVersion: "",
// 				tags: [],
// 				source: "string",
// 				productId: "",
// 				tasks: [],
// 				validators: [
// 					{
// 						message: "请选择smi文件作为输入",
// 						regex: "^.[s][m][i]$",
// 					},
// 				],
// 				choices: [],
// 				parameterGroup: "in",
// 			},
// 			{
// 				hidden: true,
// 				id: "2",
// 				name: "out",
// 				required: true,
// 				defaultValue: "",
// 				domType: "select",
// 				classType: "STRING",
// 				classTypeName: "String",
// 				value: "",
// 				description: "",
// 				language: "",
// 				languageVersion: "",
// 				tags: [],
// 				source: "string",
// 				productId: "",
// 				tasks: [],
// 				validators: [
// 					{
// 						message: "请选择smi文件作为输入",
// 						regex: "^.[s][m][i]$",
// 					},
// 				],
// 				choices: [],
// 				parameterGroup: "out",
// 			},
// 			{
// 				hidden: true,
// 				id: "3",
// 				name: "basis999",
// 				required: true,
// 				defaultValue: "",
// 				domType: "select",
// 				classType: "STRING",
// 				classTypeName: "String",
// 				value: "",
// 				description: "789",
// 				language: "",
// 				languageVersion: "",
// 				tags: [],
// 				source: "string",
// 				productId: "",
// 				tasks: [],
// 				validators: [
// 					{
// 						message: "请选择smi文件作为输入",
// 						regex: "^.[s][m][i]$",
// 					},
// 				],
// 				choices: [],
// 				parameterGroup: "basis",
// 			},
// 			{
// 				hidden: true,
// 				id: "4",
// 				name: "basis",
// 				required: true,
// 				defaultValue: "",
// 				domType: "select",
// 				classType: "STRING",
// 				classTypeName: "String",
// 				value: "",
// 				description: "",
// 				language: "",
// 				languageVersion: "",
// 				tags: [],
// 				source: "string",
// 				productId: "",
// 				tasks: [],
// 				validators: [
// 					{
// 						message: "请选择smi文件作为输入",
// 						regex: "^.[s][m][i]$",
// 					},
// 				],
// 				choices: [],
// 				parameterGroup: "basis",
// 			},
// 			{
// 				hidden: true,
// 				id: "5",
// 				name: "senior",
// 				required: true,
// 				defaultValue: "",
// 				domType: "checkbox",
// 				classType: "STRING",
// 				classTypeName: "String",
// 				value: "",
// 				description: "",
// 				language: "",
// 				languageVersion: "",
// 				tags: [],
// 				source: "string",
// 				productId: "",
// 				tasks: [],
// 				validators: [
// 					{
// 						message: "请选择smi文件作为输入",
// 						regex: "^.[s][m][i]$",
// 					},
// 				],
// 				choices: [
// 					{
// 						label: "123",
// 						value: "123",
// 					},
// 					{
// 						label: "456",
// 						value: "456",
// 					},
// 					{
// 						label: "789",
// 						value: "789",
// 					},
// 				],
// 				parameterGroup: "senior",
// 			},
// 			{
// 				hidden: true,
// 				id: "6",
// 				name: "hardware",
// 				required: true,
// 				defaultValue: "",
// 				domType: "radio",
// 				classType: "STRING",
// 				classTypeName: "String",
// 				value: "",
// 				description: "",
// 				language: "",
// 				languageVersion: "",
// 				tags: [],
// 				source: "string",
// 				productId: "",
// 				tasks: [],
// 				validators: [
// 					{
// 						message: "请选择smi文件作为输入",
// 						regex: "^.[s][m][i]$",
// 					},
// 				],
// 				choices: [
// 					{
// 						label: "123",
// 						value: "123",
// 					},
// 					{
// 						label: "456",
// 						value: "456",
// 					},
// 					{
// 						label: "789",
// 						value: "789",
// 					},
// 				],
// 				parameterGroup: "hardware",
// 			},
// 		],
// 		edges: [],
// 		isCheck: false,
// 		executionStatus: "Pending",
// 	},
// ];
// const taskId = "id";
const ParameterSetting = (props: IParameterSettingProps) => {
	const { templateConfigInfo, setTemplateConfigInfo, taskId } = props;

	// const [templateConfigInfo, setTemplateConfigInfo] = useState<ITask[]>(
	// 	templateConfigInfoMock as ITask[]
	// );

	const [descHeight, setDescHeight] = useState(0);
	const [isShowAllDese, setIsShowAllDese] = useState(false);

	const [fileSelectOpen, setFileSelectOpen] = useState(false); // 选择输出路径的弹窗显示控制

	// const [fileSelectObject, setFileSelectObject] = useState({
	// 	taskId: "",
	// 	parameterName: "",
	// });
	const [parameterName, setParameterName] = useState("");

	const div = document.getElementById("descHeight");
	useEffect(() => {
		if (div) {
			setDescHeight(div.offsetHeight);
		}
	}, [div]);

	const handleFileSelectOnClose = () => {
		setFileSelectOpen(false);
	};

	const taskInfo: ITask | null = useMemo(() => {
		if (!taskId) {
			return null;
		} else {
			const randerTaskArr = templateConfigInfo.filter(
				(task) => task.id === taskId
			);
			if (randerTaskArr.length > 0) {
				return randerTaskArr[0] as ITask;
			} else {
				return null;
			}
		}
	}, [templateConfigInfo, taskId]);

	// 设置parameter.hidden字段
	const handleHiddenChange = useCallback(
		(e: any, parameterName: string) => {
			const result: ITask[] = _.cloneDeep(templateConfigInfo);
			const taskIndex = result.findIndex((item) => {
				return item.id === taskId;
			});
			if (taskIndex !== -1) {
				let isCheck = true;
				result[taskIndex].parameters.forEach((parameter) => {
					if (parameter.name === parameterName) {
						parameter.hidden = !e.target.checked;
						const checkResult =
							getCustomTemplateParameterCheckResult(parameter);
						parameter.error = checkResult.error;
						parameter.helperText = checkResult.helperText;
					}
					if (getCustomTemplateParameterCheckResult(parameter).error === true) {
						isCheck = false;
					}
				});
				result[taskIndex].isCheck = isCheck;
			}
			setTemplateConfigInfo(result);
		},
		[templateConfigInfo, setTemplateConfigInfo, taskId]
	);

	const handleParameterChange = useCallback(
		(e: any, parameterName: string) => {
			const result: ITask[] = _.cloneDeep(templateConfigInfo);
			const taskIndex = result.findIndex((item) => {
				return item.id === taskId;
			});
			if (taskIndex !== -1) {
				let isCheck = true;
				result[taskIndex].parameters.forEach((parameter) => {
					console.log(parameter);
					if (parameter.name === parameterName) {
						parameter.defaultValue = e.target.value;
						const checkResult =
							getCustomTemplateParameterCheckResult(parameter);
						parameter.error = checkResult.error;
						parameter.helperText = checkResult.helperText;
					}
					if (getCustomTemplateParameterCheckResult(parameter).error === true) {
						isCheck = false;
					}
				});
				result[taskIndex].isCheck = isCheck;
			}
			setTemplateConfigInfo(result);
		},
		[templateConfigInfo, setTemplateConfigInfo, taskId]
	);

	const onFileSelectConfirm = (path: string) => {
		setFileSelectOpen(false);
		handleParameterChange(
			{
				target: {
					value: `ProjectData${path === "/" ? "" : path}`,
				},
			},
			parameterName
		);
	};

	const renderInput = useCallback(
		(parameter: IParameter) => {
			return (
				<Tooltip title={parameter.description} placement="top">
					<div>
						{parameter.domType.toLowerCase() === "file" && (
							<MyInput
								value={parameter.defaultValue || ""}
								InputProps={{
									endAdornment: (
										<img
											onClick={() => handleOpenFileSelect(parameter.name)}
											src={fileSelectIcon}
											alt=""
											className={styles.fileSelectImg}
										/>
									),
								}}
								placeholder="请选择"
								error={parameter.error || false}
								helperText={parameter.helperText}
								disabled={parameter.parameterGroup === "out"}
							></MyInput>
						)}
						{parameter.domType.toLowerCase() === "path" && (
							<MyInput
								value={parameter.defaultValue || ""}
								InputProps={{
									endAdornment: (
										<img
											onClick={() => handleOpenFileSelect(parameter.name)}
											src={fileSelectIcon}
											alt=""
											className={styles.fileSelectImg}
										/>
									),
								}}
								placeholder="请选择"
								error={parameter.error || false}
								helperText={parameter.helperText}
								disabled={parameter.parameterGroup === "out"}
							></MyInput>
						)}
						{parameter.domType.toLowerCase() === "dataset" && (
							<MyInput
								value={parameter.defaultValue || ""}
								InputProps={{
									endAdornment: (
										<img
											onClick={() => handleOpenFileSelect(parameter.name)}
											src={fileSelectIcon}
											alt=""
											className={styles.fileSelectImg}
										/>
									),
								}}
								placeholder="请选择"
								error={parameter.error || false}
								helperText={parameter.helperText}
								disabled={parameter.parameterGroup === "out"}
							></MyInput>
						)}
						{parameter.domType.toLowerCase() === "input" && (
							<MyInput
								value={parameter.defaultValue || ""}
								onChange={(e: any) =>
									handleParameterChange(e, parameter.name || "")
								}
								placeholder="请输入"
								error={parameter.error || false}
								helperText={parameter.helperText}
								disabled={parameter.parameterGroup === "out"}
							></MyInput>
						)}
						{parameter.domType.toLowerCase() === "select" && (
							<MySelect
								value={parameter.defaultValue}
								onChange={(e: any) =>
									handleParameterChange(e, parameter.name || "")
								}
								error={parameter.error || false}
								helpertext={parameter.helperText}
								options={optionsTransform(parameter?.choices || [], "label")}
								disabled={parameter.parameterGroup === "out"}
							></MySelect>
						)}
						{parameter.domType.toLowerCase() === "multipleselect" && (
							<MySelect
								value={parameter.defaultValue}
								onChange={(e: any) =>
									handleParameterChange(e, parameter.name || "")
								}
								multiple={true}
								error={parameter.error || false}
								helpertext={parameter.helperText}
								options={optionsTransform(parameter.choices, "label")}
								disabled={parameter.parameterGroup === "out"}
							></MySelect>
						)}
						{parameter.domType.toLowerCase() === "radio" && (
							<MyRadio
								value={parameter.defaultValue}
								onChange={(e: any) =>
									handleParameterChange(e, parameter.name || "")
								}
								options={optionsTransform(parameter.choices, "label")}
								error={parameter.error || false}
								helperText={parameter.helperText}
							></MyRadio>
						)}
						{parameter.domType.toLowerCase() === "checkbox" && (
							<MyCheckBox
								value={parameter.defaultValue}
								onChange={(e: any) =>
									handleParameterChange(
										{
											target: {
												value: e,
											},
										},
										parameter.name || ""
									)
								}
								options={optionsTransform(parameter.choices, "label")}
								error={parameter.error || false}
								helperText={parameter.helperText}
							></MyCheckBox>
						)}
					</div>
				</Tooltip>
			);
		},
		[handleParameterChange]
	);

	// 输入参数
	const inParameters: Array<IParameter> = useMemo(() => {
		if (!taskInfo) {
			return [];
		} else {
			return taskInfo.parameters.filter(
				(parameter) => parameter.parameterGroup === "in"
			);
		}
	}, [taskInfo]);

	// 输出参数
	const outParameters: Array<IParameter> = useMemo(() => {
		if (!taskInfo) {
			return [];
		} else {
			return taskInfo.parameters.filter(
				(parameter) => parameter.parameterGroup === "out"
			);
		}
	}, [taskInfo]);

	// 基础参数
	const basisParameters: Array<IParameter> = useMemo(() => {
		if (!taskInfo) {
			return [];
		} else {
			return taskInfo.parameters.filter(
				(parameter) => parameter.parameterGroup === "basis"
			);
		}
	}, [taskInfo]);

	// 高级选项
	const seniorParameters: Array<IParameter> = useMemo(() => {
		if (!taskInfo) {
			return [];
		} else {
			return taskInfo.parameters.filter(
				(parameter) => parameter.parameterGroup === "senior"
			);
		}
	}, [taskInfo]);

	// 硬件配置
	const hardwareParameters: Array<IParameter> = useMemo(() => {
		if (!taskInfo) {
			return [];
		} else {
			return taskInfo.parameters.filter(
				(parameter) => parameter.parameterGroup === "hardware"
			);
		}
	}, [taskInfo]);

	const randerParameters = useCallback(
		(parameters: Array<IParameter>) => {
			return (
				<div className={styles.parameters}>
					{parameters.map((parameter, parameterIndex) => {
						return (
							<div
								className={styles.parameter}
								key={`${parameter.name}${parameterIndex}`}
							>
								<div className={styles.parameterTop}>
									<div className={styles.parameterLeft}>
										<div
											className={classNames({
												[styles.parameterName]: true,
												[styles.required]: parameter.required,
											})}
										>
											{parameter.name}
										</div>
										<div className={styles.parameterClassTypeName}>
											{parameter.classTypeName}
										</div>
									</div>
									<MySwitch
										value={!parameter.hidden}
										onChange={(e: any) =>
											handleHiddenChange(e, parameter.name || "")
										}
									></MySwitch>
								</div>
								<div className={styles.parameterContent}>
									{renderInput(parameter)}
								</div>
							</div>
						);
					})}
				</div>
			);
		},
		[renderInput, handleHiddenChange]
	);

	const handleOpenFileSelect = (parameterName: string = "") => {
		setParameterName(parameterName);
		setFileSelectOpen(true);
	};

	// 参数组tabs
	const paramsTabList = useMemo(() => {
		return [
			{
				label: "基础参数",
				value: "basis",
				component: randerParameters(basisParameters),
				disabled: basisParameters.length === 0,
			},
			{
				label: "高级选项",
				value: "senior",
				component: randerParameters(seniorParameters),
				disabled: seniorParameters.length === 0,
			},
			{
				label: "硬件配置",
				value: "hardware",
				component: randerParameters(hardwareParameters),
				disabled: hardwareParameters.length === 0,
			},
		];
	}, [basisParameters, seniorParameters, hardwareParameters, randerParameters]);

	// 激活的参数组tab
	const activeParamsTab = useMemo(() => {
		if (basisParameters.length !== 0) {
			return "basis";
		} else if (seniorParameters.length !== 0) {
			return "senior";
		} else if (hardwareParameters.length !== 0) {
			return "hardware";
		} else {
			return "";
		}
	}, [basisParameters, seniorParameters, hardwareParameters]);

	return (
		<div className={styles.parameterSetting}>
			{taskInfo && (
				<div className={styles.taskInfo}>
					<div className={styles.taskTitle}>{taskInfo.title || "-"}</div>
					<div className={styles.taskVersion}>
						版本：{taskInfo.version || "-"}
					</div>
					<div className={styles.taskDescriptionHeight} id="descHeight">
						{taskInfo.description || "-"}
					</div>
					<div
						className={classNames({
							[styles.taskDescriptionAll]: isShowAllDese,
							[styles.taskDescription]: !isShowAllDese,
						})}
					>
						{taskInfo.description || "-"}
						{descHeight > 60 && (
							<span
								className={styles.descButton}
								onClick={() => setIsShowAllDese(!isShowAllDese)}
							>
								{isShowAllDese ? "收起" : "展开"}
							</span>
						)}
					</div>
				</div>
			)}
			{inParameters.length > 0 && (
				<div className={styles.inOutBox}>
					<div className={styles.paramsTitle}>
						输入
						<Tooltip
							title="当某个输入项为启用状态时，代表该输入将由模板使用者在使用的时候填写赋值；当为关闭状态时，代表该输入不需要使用者来填写赋值，而是将其它流程的结果传入。"
							placement="right"
						>
							<img
								className={styles.paramsTitleDesc}
								src={questionMark}
								alt=""
							/>
						</Tooltip>
					</div>
					<div className={styles.paramsList}>
						{inParameters.map((parameter, index) => {
							return (
								<div
									className={styles.inOutParameterBox}
									key={`${parameter.name}${index}`}
								>
									<div className={styles.inOutParameterTop}>
										<div className={styles.inOutParameterleft}>
											<div
												className={classNames({
													[styles.inOutParameterName]: true,
													[styles.required]: parameter.required,
												})}
											>
												{parameter.name}
											</div>
											<div className={styles.inOutParameterdataType}>
												{parameter.classTypeName}
											</div>
										</div>
										<div className={styles.inOutParameterRight}>
											<MySwitch
												value={!parameter.hidden}
												onChange={(e: any) =>
													handleHiddenChange(e, parameter.name || "")
												}
											></MySwitch>
										</div>
									</div>
									{parameter.error && parameter.helperText && (
										<div className={styles.inOutParameterHelperText}>
											{parameter.helperText}
										</div>
									)}
									{/* {renderInput(parameter)} */}
								</div>
							);
						})}
					</div>
				</div>
			)}
			{outParameters.length > 0 && (
				<div className={styles.inOutBox}>
					<div className={styles.paramsTitle}>输出</div>
					<div className={styles.paramsList}>
						{outParameters.map((parameter, index) => {
							return (
								<div
									className={styles.inOutParameterBox}
									key={`${parameter.name}${index}`}
								>
									<div className={styles.inOutParameterTop}>
										<div className={styles.inOutParameterleft}>
											<div
												className={classNames({
													[styles.inOutParameterName]: true,
													[styles.required]: parameter.required,
												})}
											>
												{parameter.name}
											</div>
											<div className={styles.inOutParameterdataType}>
												{parameter.classTypeName}
											</div>
										</div>
										<div className={styles.inOutParameterRight}></div>
									</div>
									{renderInput(parameter)}
								</div>
							);
						})}
					</div>
				</div>
			)}
			{taskInfo && (
				<div className={styles.paramsGroup}>
					<div className={styles.paramsTitle}>
						参数组
						<Tooltip
							title="当某个参数项为启用状态时，代表该参数将由模板使用者在使用的时候填写赋值；当为关闭状态时，代表该参数不需要使用者来填写赋值。"
							placement="right"
						>
							<img
								className={styles.paramsTitleDesc}
								src={questionMark}
								alt=""
							/>
						</Tooltip>
					</div>
					<Tabs
						tabList={paramsTabList}
						defaultValue={activeParamsTab}
						allowNullValue={true}
						tabPanelSx={{ padding: "7px 0" }}
					/>
				</div>
			)}
			{!taskInfo && (
				<div className={styles.noData}>
					<img src={noTemplate} alt="" className={styles.noDataImg} />
					<span className={styles.noDataText}>选中任意算子进行参数设置</span>
				</div>
			)}
			{fileSelectOpen && (
				<FileSelect
					onClose={handleFileSelectOnClose}
					open={fileSelectOpen}
					onConfirm={onFileSelectConfirm}
				/>
			)}
		</div>
	);
};

export default ParameterSetting;
