/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-21 20:03:56
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-11 14:40:34
 * @FilePath: /bkunyun/src/views/Project/ProjectSubmitWork/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import React, { useCallback, useState } from "react";
import ArrowBackIosNewIcon from "@mui/icons-material/ArrowBackIosNew";
import IconButton from "@mui/material/IconButton";

import MyPopconfirm from "@/components/mui/MyPopconfirm";
import RadioGroupOfButtonStyle from "@/components/CommonComponents/RadioGroupOfButtonStyle";
import ButtonComponent from "@/components/mui/Button";
import OperatorList from "./components/OperatorList";
import Flow from "../Project/components/Flow";
import ParameterSetting from "./components/ParameterSetting";
import { useMessage } from "@/components/MySnackbar";
import { ITask } from "../Project/ProjectSubmitWork/interface";
import _ from "lodash";
import { saveUserSpec } from "@/api/workbench_api";
import useMyRequest from "@/hooks/useMyRequest";
import MyDialog from "@/components/mui/Dialog";
import MyInput from "@/components/mui/MyInput";
import { useStores } from "@/store";
import { checkIsNumberLetterChinese } from "@/utils/util";
import { getCustomTemplateParameterCheckResult } from "./util";
import { observer } from "mobx-react-lite";
import { toJS } from "mobx";

import styles from "./index.module.css";

const radioOptions = [
	{
		value: "list",
		label: "算子列表",
	},
	{
		value: "setting",
		label: "参数设置",
	},
];

interface IProps {
	onBack?: () => void;
}

const WorkFlowEdit = observer((props: IProps) => {
	const { onBack } = props;
	const { currentProjectStore } = useStores();
	const Message = useMessage();
	const [templateConfigInfo, setTemplateConfigInfo] = useState<ITask[]>([]);
	// const projectId = toJS(currentProjectStore.currentProjectInfo.id);
	const productId = toJS(currentProjectStore.currentProductInfo.id);
	const [saveFormDialog, setSaveFormDialog] = useState(false);
	// const [formValue, setFormValue] = useState({
	// 	title: "",
	// 	version: "1.0.0",
	// 	description: "",
	// });
	const [showFlow, setShowFlow] = useState(true);
	const [title, setTitle] = useState("");
	const [version, setVersion] = useState("1.0.0");
	const [description, setDescription] = useState("");
	const [titleHelper, setTitleHelper] = useState({
		error: false,
		helperText: "",
	});
	const [versionHelper, setVersionHelper] = useState({
		error: false,
		helperText: "",
	});
	const [leftContentType, setLeftContentType] = useState("list");
	const [popperTitle, setPopperTitle] = useState(
		"返回后，当前页面已填写内容将不保存，确认返回吗？"
	);

	const checkTitle = (title: string) => {
		if (!title) {
			setTitleHelper({
				error: true,
				helperText: "必须输入模板名称",
			});
		} else if (title.length > 15) {
			setTitleHelper({
				error: true,
				helperText: "格式不正确，必须在15字符以内，仅限大小写字母、数字、中文",
			});
		} else if (!checkIsNumberLetterChinese(title)) {
			setTitleHelper({
				error: true,
				helperText: "格式不正确，必须在15字符以内，仅限大小写字母、数字、中文",
			});
		} else {
			setTitleHelper({
				error: false,
				helperText: "",
			});
		}
	};
	const checkVersion = (version: string) => {
		const versionArr = version.split(".");
		const reg = new RegExp("^([0-9]|[0-9]\\d)$");
		// var a=101;
		// if(!reg.test(a)) {
		//         alert("请输入1-100的整数！")

		//     }
		console.log(versionArr);
		if (versionArr.length !== 3) {
			setVersionHelper({
				error: true,
				helperText: "格式不正确，必须为X.Y.Z格式，且XYZ必须为0~99的正整数",
			});
		} else if (
			versionArr.every((item) => {
				console.log(item);
				console.log(reg.test(item));
				return reg.test(item);
			})
		) {
			setVersionHelper({
				error: false,
				helperText: "",
			});
		} else {
			setVersionHelper({
				error: true,
				helperText: "格式不正确，必须为X.Y.Z格式，且XYZ必须为0~99的正整数",
			});
		}
	};
	const handleTitleChange = (e: any) => {
		console.log(e);
		const title = e.target.value;
		console.log(title);
		setTitle(title);
		checkTitle(title);
		// 格式不正确，必须在15字符以内，仅限大小写字母、数字、中文
	};
	const handleVersionChange = (e: any) => {
		let version = e.target.value;
		setVersion(version);
		checkVersion(version);
		console.log(e);
		// version
	};
	const handleDescriptionChange = (e: any) => {
		let description = e.target.value;
		if (description.length < 301) {
			setDescription(description);
		}
	};
	const { run: saveUserSpecRun } = useMyRequest(saveUserSpec, {
		onSuccess: (res) => {
			Message.success("保存成功!");
			setShowFlow(true);
			onBack && onBack();
		},
	});

	const [anchorEl, setAnchorEl] = useState<any>(null);
	const handleCancel = () => {
		setAnchorEl(null);
	};

	const handleShowPopper = (e: any, title: string) => {
		setPopperTitle(title);
		setAnchorEl(anchorEl ? null : e.currentTarget);
	};

	const handleConfirm = () => {
		if (popperTitle === "返回后，当前页面已填写内容将不保存，确认返回吗？") {
			onBack && onBack();
		}
	};

	const handlePreserve = () => {
		console.log("提交");
		console.log(templateConfigInfo);
		// 校验
		if (templateConfigInfo.length === 0) {
			Message.error("工作流不能为空！");
			return;
		}
		let templateConfigInfoClone: ITask[] = _.cloneDeep(templateConfigInfo);
		let check = true;
		templateConfigInfoClone.forEach((task) => {
			task.parameters.forEach((parameter) => {
				const checkResult = getCustomTemplateParameterCheckResult(parameter);
				parameter.error = checkResult.error;
				parameter.helperText = checkResult.helperText;
				if (checkResult.error) {
					console.log(parameter);
					check = false;
				}
			});
		});
		setTemplateConfigInfo(templateConfigInfoClone);
		if (!check) {
			Message.error("工作流校验未通过，请检查！");
		} else {
			console.log("弹表单窗");
			setShowFlow(false);
			setSaveFormDialog(true);
			// saveUserSpecRun({
			// 	title: "自定义模板标题",
			// 	version: "1.0.0",
			// 	description: "这里是描述",
			// 	tasks: templateConfigInfoClone,
			// 	// projectId,
			// 	productId,
			// });
		}
	};

	const handleCloseDialog = () => {
		setSaveFormDialog(false);
	};

	const handleOncofirm = () => {
		checkTitle(title);
		checkVersion(version);
		if (!titleHelper.error && !versionHelper.error) {
			saveUserSpecRun({
				title,
				version,
				description,
				tasks: templateConfigInfo,
				productId,
			});
		}
	};

	/** 选中的task 唯一标识符 */
	const [selectTaskId, setSelectTaskId] = useState<string>();

	/** 设置选中唯一标识符 */
	const handleNodeClick = useCallback((val: string) => {
		setSelectTaskId(val);
	}, []);

	return (
		<div className={styles.swBox}>
			<div className={styles.swHeader}>
				<div className={styles.swHeaderLeft}>
					<IconButton
						color="primary"
						aria-label="upload picture"
						component="span"
						size="small"
						onClick={(e: any) =>
							handleShowPopper(
								e,
								"返回后，当前页面已填写内容将不保存，确认返回吗？"
							)
						}
					>
						<ArrowBackIosNewIcon
							sx={{
								color: "rgba(194, 198, 204, 1)",
								width: "12px",
								height: "12px",
							}}
						/>
					</IconButton>
				</div>
				<div className={styles.swHeaderRight}>
					<ButtonComponent
						text="保存"
						click={() => handlePreserve()}
					></ButtonComponent>
				</div>
			</div>
			<div className={styles.swContent}>
				<div className={styles.swFormBox}>
					<div className={styles.radiosBox}>
						<RadioGroupOfButtonStyle
							radioOptions={radioOptions}
							value={leftContentType}
							handleRadio={setLeftContentType}
							RadiosBoxStyle={{
								height: "36px",
								padding: "3px",
							}}
							radioStyle={{
								fontSize: "16px",
								height: "30px",
							}}
						></RadioGroupOfButtonStyle>
					</div>
					{leftContentType === "list" && (
						<OperatorList
							templateConfigInfo={templateConfigInfo}
							setTemplateConfigInfo={setTemplateConfigInfo}
						/>
					)}
					{leftContentType !== "list" && (
						<ParameterSetting
							templateConfigInfo={templateConfigInfo}
							setTemplateConfigInfo={setTemplateConfigInfo}
							taskId={selectTaskId || ""}
						/>
					)}
				</div>
				<div className={styles.swFlowBox} id="workFlowEditRight">
					{showFlow && (
						<Flow
							tasks={templateConfigInfo}
							setTasks={setTemplateConfigInfo}
							type="edit"
							onFlowNodeClick={handleNodeClick}
						/>
					)}
				</div>
			</div>
			<MyPopconfirm
				title={popperTitle}
				anchorEl={anchorEl}
				onCancel={handleCancel}
				onConfirm={handleConfirm}
			/>
			{saveFormDialog && (
				<MyDialog
					open={saveFormDialog}
					title="保存自定义模板"
					onClose={handleCloseDialog}
					onConfirm={handleOncofirm}
				>
					<div>
						<MyInput
							value={title}
							label="模板名称"
							onChange={handleTitleChange}
							required
							error={titleHelper.error}
							helperText={titleHelper.helperText}
							style={{ margin: "20px 0" }}
						></MyInput>
						<MyInput
							value={version}
							label="版本号"
							onChange={handleVersionChange}
							error={versionHelper.error}
							helperText={versionHelper.helperText}
							style={{ marginBottom: "20px" }}
						></MyInput>
						<MyInput
							value={description}
							label="模板描述"
							placeholder="模板描述"
							onChange={handleDescriptionChange}
							multiline
							rows={4}
						></MyInput>
					</div>
				</MyDialog>
			)}
		</div>
	);
});

export default WorkFlowEdit;
