import { ITemplateConfig, IRenderTasks, IRenderTask } from "../interface";
import styles from "./index.module.css";
import MyInput from "@/components/mui/MyInput";
import Tooltip from "@mui/material/Tooltip";
import classnames from "classnames";
import { useState, useMemo } from "react";
import FileSelect from "@/components/FileSelect";
import moment from "moment";
import MySelect, { optionsTransform } from "../components/MySelect";
import MyCheckBox from "@/components/mui/MyCheckBox";
import MyRadio from "@/components/mui/MyRadio";
import _ from "lodash";
import fileSelectIcon from "@/assets/project/fileSelect.svg";
import questionMark from "@/assets/project/questionMark.svg";

type ConfigFormProps = {
  templateConfigInfo: ITemplateConfig;
  setParameter: any;
};

const ConfigForm = (props: ConfigFormProps) => {
  const { templateConfigInfo, setParameter } = props;
  const [name, setName] = useState<string>(
    `${templateConfigInfo.title}_${moment(new Date()).format(
      "YYYY_MM_DD_HH_mm"
    )}`
  ); // 任务名称
  const [outputPath, setOutputPath] = useState<string>("ProjectData"); // 输出路径
  const [fileSelectOpen, setFileSelectOpen] = useState(false); // 选择输出路径的弹窗显示控制

  const onFileSelectConfirm = (path: string) => {
    setFileSelectOpen(false);
    setOutputPath(`ProjectData${path === "/" ? "" : path}`);
  };

  const handleFileSelectOnClose = () => {
    setFileSelectOpen(false);
  };

  const handleOpenFileSelect = () => {
    setFileSelectOpen(true);
  };

  const handleNameChange = (e: any) => {
    setName(e.target.value);
  };

  const renderTasks: IRenderTasks = useMemo(() => {
    const result: IRenderTasks = [];
    templateConfigInfo.tasks.forEach((task, taskIndex) => {
      if (task.type === "BATCH") {
        result.push({ ...task, flows: [] });
      } else {
        result[result.length - 1]?.flows.push({ ...task });
      }
    });
    return result;
  }, [templateConfigInfo]);

  console.log(renderTasks);

  // const options = [
  //   {
  //     key: "1aaaaa",
  //     value: "a",
  //   },
  //   {
  //     key: "bbbbbb",
  //     value: "b",
  //   },
  //   {
  //     key: "cccccc",
  //     value: "c",
  //   },
  //   {
  //     key: "dddddd",
  //     value: "d",
  //   },
  //   {
  //     key: "bbbbbb",
  //     value: "e",
  //   },
  //   {
  //     key: "cccccc",
  //     value: "f",
  //   },
  //   {
  //     key: "dddddd",
  //     value: "g",
  //   },
  // ];

  // path : [a, b]

  // const [selectValue, setSelectValue] = useState("b");
  // const [selectValue, setSelectValue] = useState<Array<any>>([]);
  // const handleSelectChange = (e: any) => {
  //   console.log(e);
  //   setSelectValue(e.target.value);
  // };

  // const handleCheckBoxChange = (e: any) => {
  //   setSelectValue(e);
  // };

  // const handleRadioChange = (e: any) => {
  //   console.log(e);
  //   setSelectValue(e.target.value);
  // };

  // const renderFormItem = (domtype) => {

  // }

  const handleParameterChange = (
    e: any,
    taskId: string,
    parameterName: string
  ) => {
    console.log(e, taskId, parameterName);
    setParameter(e.target.value, taskId, parameterName);
  };

  return (
    <div className={styles.formBox}>
      <div className={styles.templateDescBox}>
        <div className={styles.templateDescTitle}>模板描述</div>
        <div className={styles.templateDesc}>
          {templateConfigInfo.description}
        </div>
      </div>
      <div
        className={classnames({
          [styles.backgroundTitle]: true,
          [styles.backgroundTitlePass]: true,
        })}
      >
        <img src="" alt="" />
        <span className={styles.backgroundTitleText}>基础信息</span>
      </div>
      <div className={styles.formItems}>
        <div className={styles.formItem}>
          <div
            className={classnames({
              [styles.formItemLable]: true,
              [styles.required]: true,
            })}
          >
            任务名称
          </div>
          <div className={styles.formItem}>
            <MyInput
              value={name}
              onChange={handleNameChange}
              placeholder="请输入任务名称"
            ></MyInput>
          </div>
        </div>
        <div className={styles.formItem}>
          <div
            className={classnames({
              [styles.formItemLable]: true,
              [styles.required]: true,
            })}
          >
            输出路径
          </div>
          <div className={styles.formItem}>
            <MyInput
              value={outputPath}
              InputProps={{
                endAdornment: (
                  <img
                    onClick={handleOpenFileSelect}
                    src={fileSelectIcon}
                    alt="选择输出路径"
                    className={styles.fileSelectImg}
                  />
                ),
              }}
            ></MyInput>
          </div>
        </div>
      </div>
      {renderTasks.map((task, taskIndex) => {
        return (
          <div className={styles.taskBox} key={task.id + taskIndex}>
            <div
              className={classnames({
                [styles.backgroundTitle]: true,
                [styles.backgroundTitlePass]: true,
              })}
            >
              {/* <img src="" alt="" /> */}
              <span>下面的子项校验是否通过</span>
              <span className={styles.backgroundTitleText}>{task.title}</span>
            </div>
            <div className={styles.taskConfigBox}>
              {task.parameters.map((parameter, parameterIndex) => {
                return (
                  <div
                    className={styles.parameter}
                    key={parameter.id || "" + parameterIndex}
                  >
                    <div className={styles.parameterTitle}>
                      {parameter.name}
                      <span className={styles.parameterDataType}>
                        {parameter.dataType}
                      </span>
                    </div>
                    {parameter.domType.toLowerCase() === "input" && (
                      <MyInput
                        value={parameter.value}
                        onChange={(e: any) =>
                          handleParameterChange(
                            e,
                            task.id,
                            parameter.name || ""
                          )
                        }
                        placeholder="请输入"
                      ></MyInput>
                    )}
                    {/* {parameter.domType.toLowerCase()} */}
                    {parameter.description && (
                      <Tooltip title={parameter.description} placement="top">
                        <img
                          className={styles.parameterDesc}
                          src={questionMark}
                          alt=""
                        />
                      </Tooltip>
                    )}
                    {/* question mark */}
                  </div>
                );
              })}
            </div>
          </div>
        );
      })}
      {/* <MySelect
        value={selectValue}
        onChange={handleSelectChange}
        multiple={true}
        options={optionsTransform(options, "key")}
      ></MySelect> */}
      {/* <MyCheckBox
        value={selectValue}
        onChange={handleCheckBoxChange}
        options={optionsTransform(options, "key")}
      ></MyCheckBox> */}
      {/* <MyRadio
        value={selectValue}
        onChange={handleRadioChange}
        options={optionsTransform(options, "key")}
      ></MyRadio> */}
      {/* <FileSelect
        onClose={handleFileSelectOnClose}
        open={fileSelectOpen}
        onConfirm={onFileSelectConfirm}
      /> */}
    </div>
  );
};

export default ConfigForm;
