import { ITemplateConfig, IEdge } from "../../ProjectSubmitWork/interface";
import ReactFlow, {
  addEdge,
  MiniMap,
  Controls,
  Background,
  useNodesState,
  useEdgesState,
  Handle,
  Position,
} from "react-flow-renderer";
import { useCallback, useMemo } from "react";

import styles from "./index.module.css";
import classNames from "classnames";
/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-06-22 10:15:22
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-06-22 11:10:35
 * @FilePath: /bkunyun/src/views/Project/components/Flow/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
interface IProps {
  data: ITemplateConfig;
}

const BatchNode = (props: any) => {
  const { data } = props;
  return (
    <div
      className={classNames({
        [styles.batchNode]: true,
        [styles.selectBatchNode]: false,
      })}
      style={data.style}
    >
      <Handle type="target" position={Position.Top} />
      <div
        className={classNames({
          [styles.batchRotate]: false,
        })}
      >
        {data.label || ""}
      </div>
      <Handle type="source" position={Position.Bottom} id="a" />
    </div>
  );
};

const FlowNode = (props: any) => {
  const { data } = props;
  return (
    <div
      className={classNames({
        [styles.flowNode]: true,
      })}
    >
      <Handle type="target" position={Position.Top} />
      <div>{data.label || ""}</div>
      <Handle type="source" position={Position.Bottom} id="a" />
    </div>
  );
};

const Flow = (props: IProps) => {
  const { data } = props;

  const nodeTypes = useMemo(() => {
    return { batchNode: BatchNode, flowNode: FlowNode };
  }, []);

  const getBatchStyle = useCallback(
    (id: string) => {
      const positionXArr: number[] = [];
      const positionYArr: number[] = [];
      data?.tasks?.length &&
        data?.tasks?.forEach((item) => {
          if (item.parentNode === id) {
            positionXArr.push(item.position?.x || 0);
            positionYArr.push(item.position?.y || 0);
          }
        });
      positionXArr.sort((a, b) => {
        return a - b;
      });
      positionYArr.sort((a, b) => {
        return a - b;
      });
      let width = 176,
        height = 44;
      if (positionXArr?.length) {
        const val = positionXArr[positionXArr.length - 1] - positionXArr[0];
        width = val ? val : width;
      }
      if (positionXArr?.length) {
        const val = positionYArr[positionYArr.length - 1] - positionYArr[0];
        height = val ? val : height;
      }
      return {
        width,
        height,
      };
    },
    [data?.tasks]
  );

  const initialNodes = useMemo(() => {
    const val: any = [];
    data?.tasks?.length &&
      data?.tasks.forEach((item) => {
        if (item.type === "BATCH") {
          console.log(getBatchStyle(item.id));
        }
        val.push({
          id: item.id,
          type: item.type === "BATCH" ? "batchNode" : "flowNode",
          data: { label: item.title || "", style: getBatchStyle(item.id) },
          position: item.position,
          //   style: { width: 176, height: 500 },
          ...(item.type === "BATCH" ? { style: getBatchStyle(item.id) } : {}),
          ...(item.parentNode ? { parentNode: item.parentNode } : {}),
          ...(item.type === "BATCH" ? { extent: "parent" } : {}),
        });
      });
    return val;
  }, [data?.tasks, getBatchStyle]);

  const initialEdges = useMemo(() => {
    const val: any = [];
    data?.tasks?.length &&
      data?.tasks.forEach((item) => {
        val.push(...item.edges);
      });
    val.map((item: IEdge) => {
      return {
        id: item.id,
        label: item.label,
        source: item.source,
        target: item.target,
      };
    });
    return val;
  }, [data]);

  console.log(initialEdges, initialNodes, 11111);

  const [nodes, setNodes, onNodesChange] = useNodesState<any>(initialNodes);
  const [edges, setEdges, onEdgesChange] = useEdgesState(initialEdges);

  const onConnect = (params: any) => setEdges((eds) => addEdge(params, eds));

  const onInit = (reactFlowInstance: any) =>
    console.log("flow loaded:", reactFlowInstance);
  return (
    <ReactFlow
      nodes={nodes}
      edges={edges}
      onNodesChange={onNodesChange}
      onEdgesChange={onEdgesChange}
      onConnect={onConnect}
      onInit={onInit}
      fitView
      attributionPosition="top-right"
      nodeTypes={nodeTypes}
    >
      <MiniMap
        // nodeStrokeColor={(n) => {
        //   if (n.style?.background) return n.style.background;
        //   if (n.type === "input") return "#0041d0";
        //   if (n.type === "output") return "#ff0072";
        //   if (n.type === "default") return "#1a192b";

        //   return "#eee";
        // }}
        // nodeColor={(n) => {
        //   if (n.style?.background) return n.style.background;

        //   return "#fff";
        // }}
        nodeBorderRadius={2}
      />
      <Controls />
      <Background color="#aaa" gap={16} />
    </ReactFlow>
  );
};

export default Flow;
