import OutlinedInput, { OutlinedInputProps } from "@mui/material/OutlinedInput";
import { ThemeProvider, createTheme } from "@mui/material/styles";
import SearchIcon from "@mui/icons-material/Search";

// 使用该搜索框组件时，width、height、font-size等样式属性可以在组件sx属性中覆盖掉当前组件内的样式
// 该组件默认搜索框高度为32px，宽度和容器一致，字体大小14px
// 若想自定义修改，写法：<SearchInput sx={{ width: 340 ,height: 36 ,fontSize: 12}} />

interface SearchInputProps extends OutlinedInputProps {
    value?: any;
    variant?: "standard" | "filled" | "outlined";
    size?: "small" | "medium";
    placeholder?: string;
    fullWidth?: boolean; // 宽度是否和容器一致
    error?: boolean;
};
const SearchInput = (props: SearchInputProps) => {
    const {
        size = "small",
        placeholder = "输入关键词搜索",
        fullWidth = true,
        ...other
    } = props;

    const theme = createTheme({
        components: {
            MuiOutlinedInput: {
                styleOverrides: {
                    root: {
                        height: "32px",
                        fontSize: "14px",
                        paddingRight: "8px",
                        ":hover": {
                            "& .MuiOutlinedInput-notchedOutline": {
                                borderColor: "#1370ff",
                            },
                        },
                    },
                    input: {
                        padding: "5px 12px",
                        verticalAlign: "middle",
                    },
                },
            },
        },
    });

    return (
        <ThemeProvider theme={theme}>
            <OutlinedInput
                size={size}
                placeholder={placeholder}
                fullWidth={fullWidth}
                endAdornment={<SearchIcon style={{ color: "#999" }} />}
                {...other}
            />
        </ThemeProvider>
    );
}

export default SearchInput