/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-07-05 14:00:37
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-21 17:33:59
 * @FilePath: /bkunyun/src/components/mui/MyInput.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import TextField, { TextFieldProps } from "@mui/material/TextField";
import { ThemeProvider, createTheme } from "@mui/material/styles";

interface MyInputProps extends Omit<TextFieldProps, "value"> {
	value?: string;
	variant?: "standard" | "filled" | "outlined";
	size?: "small" | "medium";
	placeholder?: string;
	fullWidth?: boolean; // 宽度是否和容器一致
	error?: boolean;
}

const MyInput = (props: MyInputProps) => {
	const {
		size = "medium",
		placeholder = "请输入",
		fullWidth = true,
		error = false,
		label,
		...other
	} = props;

	const theme = createTheme({
		components: {
			MuiInputBase: {
				styleOverrides: {
					root: {
						height: "36px",
						fontSize: "14px",
						"&.MuiInputBase-sizeSmall": {
							height: "32px",
							"& .MuiOutlinedInput-notchedOutline": {
								height: "34px",
							},
						},
					},
				},
			},

			MuiInputLabel: {
				styleOverrides: {
					root: {
						top: label ? "-5px" : "-10px",
					},
				},
			},
			MuiOutlinedInput: {
				styleOverrides: {
					root: {
						height: "36px",
						lineHeight: "36px",
						paddingRight: "12px",
						":hover": {
							"& .MuiOutlinedInput-notchedOutline": error
								? {}
								: {
										borderColor: "#1370ff",
								  },
						},
					},
					input: {
						padding: "6.5px 12px",
						verticalAlign: "middle",
					},
					notchedOutline: {
						height: "36px",
					},
				},
			},
		},
	});

	return (
		<ThemeProvider theme={theme}>
			<TextField
				error={error}
				size={size}
				placeholder={placeholder}
				fullWidth={fullWidth}
				label={label}
				{...other}
			/>
		</ThemeProvider>
	);
};

export default MyInput;
