/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生#A02208 yongsheng.wu@wholion.com
 * @LastEditTime: 2022-07-21 11:34:55
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
// import Dialog from "@/components/Material.Ui/Dialog";
import { memo, useEffect, useState } from "react";
import { observer } from "mobx-react-lite";
import { toJS } from "mobx";

import MySelect, { IOption } from "@/components/mui/MySelect";
import Dialog from "@/components/mui/MyDialog";
import { IResponse, useHttp } from "@/api/http";
import { useStores } from "@/store/index";
import { IDialogInfo } from "../interface";
import { useMessage } from "@/components/MySnackbar";

interface IProps {
	setPermissionDialog: (val: IDialogInfo) => void;
	permissionDialog: IDialogInfo;
	getTableList: () => void;
}

const ChangePermission = observer((props: IProps) => {
	const { permissionDialog, setPermissionDialog, getTableList } = props;

	const { currentProjectStore } = useStores();
	const Message = useMessage();
	const http = useHttp();

	const [selectOptions, setSelectOptions] = useState<IOption[]>([]);
	const [selectValue, setSelectValue] = useState<string | undefined>();

	useEffect(() => {
		if (permissionDialog?.isShow) {
			http.get<IResponse<any>>("/cpp/project/listroles").then((res) => {
				const arr = [];
				const { data } = res;
				for (const key in data) {
					arr.push({
						label: String(data[key]),
						value: key,
					});
				}
				setSelectOptions(arr);
			});
		}
	}, [http, permissionDialog]);

	const changePermission = (val: any) => {
		setSelectValue(val);
	};
	const onClose = () => {
		setPermissionDialog({ isShow: false, username: "" });
	};
	const onConfirm = () => {
		const projectInfo = toJS(currentProjectStore?.currentProjectInfo);
		http
			.put<IResponse<any>>(
				`/cpp/project/updateuserrole?id=${projectInfo?.id || ""}&username=${
					permissionDialog.username
				}&role=${selectValue}`
			)
			.then((res) => {
				const { errorCode } = res;
				if (errorCode === 0) {
					Message.success("更改成功！");
					getTableList();
					setPermissionDialog({ isShow: false, username: "" });
				}
			});
	};

	useEffect(() => {
		const defaultValue = selectOptions.filter(
			(every) => every.value === permissionDialog?.projectRole
		);
		if (defaultValue?.length) {
			setSelectValue(defaultValue[0]?.value);
		} else {
			setSelectValue("VIEWER");
		}
	}, [permissionDialog, selectOptions]);
	return (
		<>
			<Dialog
				open={permissionDialog?.isShow}
				onClose={onClose}
				onConfirm={onConfirm}
				title="更改权限"
			>
				<div style={{ marginTop: 12 }}>
					<MySelect
						title="项目权限"
						isTitle={true}
						value={selectValue}
						onChange={changePermission}
						options={selectOptions}
						size="small"
					/>
				</div>
			</Dialog>
		</>
	);
});

export default memo(ChangePermission);
