/*
 * @Author: 吴永生#A02208 yongsheng.wu@wholion.com
 * @Date: 2022-05-31 10:18:13
 * @LastEditors: 吴永生 15770852798@163.com
 * @LastEditTime: 2022-07-26 18:34:46
 * @FilePath: /bkunyun/src/views/Project/ProjectSetting/index.tsx
 * @Description: 这是默认设置,请设置`customMade`, 打开koroFileHeader查看配置 进行设置: https://github.com/OBKoro1/koro1FileHeader/wiki/%E9%85%8D%E7%BD%AE
 */
import { memo, useEffect, useState } from "react";
import { Box, Typography } from "@mui/material";
import OutlinedInput from "@mui/material/OutlinedInput";
import SearchIcon from "@mui/icons-material/Search";
import { toJS } from "mobx";
import { observer } from "mobx-react-lite";
import Add from "@mui/icons-material/Add";

import MyButton from "@/components/mui/MyButton";
import useMyRequest from "@/hooks/useMyRequest";
import TemplateBox from "./components/templateBox";
import SimpleDialog from "./components/simpleDialog";
import AddTemplate from "./components/AddTemplate/index";
import noData from "../../../../assets/project/noTemplate.svg";
import {
	getWorkbenchTemplate,
	deleteWorkbenchTemplate,
} from "@/api/workbench_api";
import usePass from "@/hooks/usePass";
import { useStores } from "@/store";

import styles from "./index.module.css";

const ProjectMembers = observer(() => {
	const { currentProjectStore } = useStores();
	const projectIdData = toJS(currentProjectStore.currentProjectInfo.id);
	const productId = toJS(currentProjectStore.currentProductInfo.id);
	const isPass = usePass();

	/** 搜索模板名称 */
	const [templateName, setTemplateName] = useState("");
	/** 模板列表 */
	const [templateList, setTemplateList] = useState([]);
	/** 选中的模板id */
	const [templateId, setTemplateId] = useState("");
	/** 简单弹窗（删除模板） */
	const [openDialog, setOpenDialog] = useState(false);
	const [showAddTemplate, setShowAddTemplate] = useState(false);

	// 获取模板列表
	const { run: getTemplateInfo } = useMyRequest(getWorkbenchTemplate, {
		onSuccess: (result: any) => {
			setTemplateList(result.data);
		},
	});

	// 删除模板
	const { run: delTemplate } = useMyRequest(deleteWorkbenchTemplate, {
		onSuccess: (result: any) => {
			setOpenDialog(false);
			getTemplateInfo({
				projectId: currentProjectStore.currentProjectInfo.id as string,
				title: templateName,
			});
		},
	});

	useEffect(() => {
		getTemplateInfo({
			projectId: currentProjectStore.currentProjectInfo.id as string,
		});
	}, [currentProjectStore.currentProjectInfo.id, getTemplateInfo]);

	/** 删除模板 */
	const deleteTemplate = () => {
		delTemplate({
			projectId: currentProjectStore.currentProjectInfo.id as string,
			workflowSpecId: templateId,
		});
	};

	/** 打开弹窗 */
	const startDialog = (id: string) => {
		setTemplateId(id);
		setOpenDialog(true);
	};

	/** 关闭弹窗 */
	const closeDialog = () => {
		setOpenDialog(false);
	};

	/** 增加模板 */
	const addTemplateBlock = () => {
		setShowAddTemplate(true);
	};

	const searchChange = (data: any) => {
		setTemplateName(data.length > 30 ? data.slice(0, 30) : data);
	};

	useEffect(() => {
		setTimeout(() => {
			getTemplateInfo({
				projectId: projectIdData as string,
				title: templateName,
			});
		}, 300);
	}, [templateName, getTemplateInfo, projectIdData]);

	return (
		<Box className={styles.headerBox}>
			<Box className={styles.tabBox}>
				<OutlinedInput
					onChange={(e: any) => {
						searchChange(e.target.value);
					}}
					value={templateName}
					placeholder="输入关键词搜索"
					size="small"
					sx={{ width: 340, height: 32 }}
					endAdornment={<SearchIcon style={{ color: "#8A9099" }} />}
				/>

				{templateList.length > 0 &&
					isPass("PROJECT_WORKBENCH_FLOES_ADD", "MANAGER") && (
						<MyButton
							text={"添加工作流模版"}
							img={<Add />}
							onClick={addTemplateBlock}
							size={"small"}
						/>
					)}
			</Box>

			{templateList.length === 0 && templateName.length > 0 && (
				<Box
					sx={{
						display: "flex",
						alignItems: "center",
						flexDirection: "column",
						minHeight: "calc(100vh - 376px)",
						justifyContent: "center",
					}}
				>
					<img alt="" src={noData} />
					<Typography
						sx={{ fontSize: "12px", fontWeight: "400", color: "#8A9099" }}
					>
						暂未开启模版
					</Typography>
				</Box>
			)}
			{templateList.length > 0 && (
				<Box sx={{ display: "flex", flexWrap: "wrap", marginLeft: "-8px" }}>
					{templateList &&
						templateList.length > 0 &&
						templateList.map((item, key) => {
							return (
								<TemplateBox key={key} data={item} startDialog={startDialog} />
							);
						})}
				</Box>
			)}
			{templateList.length === 0 &&
				templateName.length === 0 &&
				isPass("PROJECT_WORKBENCH_FLOES_ADD", "MANAGER") && (
					<Box className={styles.addNewTemplate} onClick={addTemplateBlock}>
						<Add
							sx={{
								color: "#565C66",
								fontSize: "20px",
								width: "30px",
								height: "30px",
							}}
						/>
						<Typography
							sx={{
								fontSize: "14px",
								fontWeight: "400",
								color: "#8A9099",
								marginTop: "15px",
							}}
						>
							添加工作流模版
						</Typography>
					</Box>
				)}

			{showAddTemplate && (
				<AddTemplate
					setShowAddTemplate={() => setShowAddTemplate(false)}
					getTemplateInfo={getTemplateInfo}
					productId={productId as string}
					projectId={projectIdData as string}
				/>
			)}

			<SimpleDialog
				text={"确认移除该模板吗？"}
				title={"删除模板"}
				openDialog={openDialog}
				closeDialog={closeDialog}
				onConfirm={deleteTemplate}
			/>
		</Box>
	);
});

export default memo(ProjectMembers);
